import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    assert site_name is not None, "site_name 不能为空！"

    db_type = 'mysql'
    import_table = f"{site_name}_self_asin_detail"
    sql_query = f"""
        select 
            id,
            asin,
            together_asin, 
            sp_initial_seen_asins_json, 
            sp_4stars_initial_seen_asins_json, 
            sp_delivery_initial_seen_asins_json, 
            compare_similar_asin_json, 
            result_list_json, 
            updated_at, 
            bundle_asin_component_json 
        from {import_table} 
        where site = '{site_name}' 
        and DATE(updated_at) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) 
        and \$CONDITIONS
    """

    hive_table = "ods_self_asin_related_traffic"
    partition_dict = {
        "site_name": site_name
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    if site_name == 'us':
        map_num = 25
    else:
        map_num = 1

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=sql_query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        m=map_num,
        split_by='id',
        check_count=False
    )

    pass
