import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.common_util import DateTypes
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    suffix = str(date_info).replace("-", "_")
    import_table = f"{site_name}_seller_account_feedback_{suffix}"
    if date_type == DateTypes.month.name and date_info >= '2023-08':
        db_type = 'postgresql_14'
    else:
        db_type = 'postgresql'
    print("当前链接的数据库为：", db_type)

    sql_query = f"""
        select 
            seller_id,
            site_name as country_name,
            count_30_day,
            count_1_year,
            count_lifetime,
            num,
            created_at,
            updated_at,
            seller_address
        from {import_table} 
        where 1=1
        and \$CONDITIONS
    """

    hive_table = "ods_seller_account_feedback"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=sql_query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict
    )

    pass
