import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.db_util import DBUtil
from utils.spark_util import SparkUtil

if __name__ == '__main__':
    # 获取入参
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    print(f"执行参数为{sys.argv}")
    CommonUtil.judge_is_work_hours(site_name=site_name, date_type=date_type, date_info=date_info,
                                   principal='chenyuanjie', priority=1, export_tools_type=1)

    # 导出字段
    columns = ["st_key", "search_term", "st_volume", "st_rank", "st_orders", "years",
               "created_time", "updated_time", "date_type", "date_info"]

    # 导出月数据
    print("导出月趋势图到PG：")
    db_type = "postgresql"
    year_str = CommonUtil.safeIndex(date_info.split("-"), 0, None)
    year_next = str(int(year_str) + 1)
    export_master_tb = f"{site_name}_aba_last_total_time"
    export_table = f"{export_master_tb}_{year_str}"
    engine = DBUtil.get_db_engine(db_type, site_name)
    sql = f"""
        create table if not exists {export_table} partition of {export_master_tb} for values from ('{year_str}') to ('{year_next}');
        delete from {export_table} where date_info = '{date_info}';
    """
    DBUtil.engine_exec_sql(engine, sql)
    # sqoop导出的sh脚本编写
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_st_base_report",
        export_tb=export_table,
        col=columns,
        partition_dict={
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        }
    )
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
    print("导出月趋势图完成！")

    # 导出周数据
    # date_info对应的week_list
    spark = SparkUtil.get_spark_session(f"export_dwt_st_base_report:{site_name} {date_type} {date_info}")
    sql = f""" 
        select year_week from dim_date_20_to_30 where week_day = 1 and year_month = '{date_info}';
    """
    df_week = spark.sql(sql)
    week_list = sorted([row['year_week'] for row in df_week.collect()])
    for year_week in week_list:
        print(f"导出周趋势图到PG集群：{year_week}周")
        db_type = "postgresql_cluster"
        year_str = CommonUtil.safeIndex(year_week.split("-"), 0, None)
        year_next = str(int(year_str) + 1)
        export_master_tb = f"{site_name}_aba_last_total_week"
        export_table = f"{export_master_tb}_{year_str}"
        engine = DBUtil.get_db_engine(db_type, site_name)
        sql = f"""
            create table if not exists {export_table} partition of {export_master_tb} for values from ('{year_str}') to ('{year_next}');
            delete from {export_table} where date_info = '{year_week}';
        """
        DBUtil.engine_exec_sql(engine, sql)
        # sqoop导出的sh脚本编写
        sh = CommonUtil.build_export_sh(
            site_name=site_name,
            db_type=db_type,
            hive_tb="dwt_st_base_report",
            export_tb=export_table,
            col=columns,
            partition_dict={
                "site_name": site_name,
                "date_type": 'week',
                "date_info": year_week
            }
        )
        client = SSHUtil.get_ssh_client()
        SSHUtil.exec_command_async(client, sh, ignore_err=False)
        client.close()
        print(f"导出周趋势图{year_week}周完成！")

    pass
