/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.io;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.util.Shell;
import org.apache.log4j.Logger;

public class NamedFifo {
    private static final Logger LOG = Logger.getLogger(NamedFifo.class);
    private File fifoFile;

    public NamedFifo(String pathname) {
        this.fifoFile = new File(pathname);
    }

    public NamedFifo(File fifo) {
        this.fifoFile = fifo;
    }

    public File getFile() {
        return this.fifoFile;
    }

    public void create() throws IOException {
        this.create(384);
    }

    public void create(int permissions) throws IOException {
        String output;
        String filename = this.fifoFile.toString();
        String modeStr = Integer.toString(permissions, 8);
        try {
            output = Shell.execCommand((String[])new String[]{"mknod", "--mode=0" + modeStr, filename, "p"});
            LOG.info((Object)("mknod output:\n" + output));
        }
        catch (IOException ex) {
            LOG.info((Object)("IO error running mknod: " + ex.getMessage()));
            LOG.debug((Object)"IO error running mknod", (Throwable)ex);
        }
        if (!this.fifoFile.exists()) {
            LOG.info((Object)"mknod failed, falling back to mkfifo");
            output = Shell.execCommand((String[])new String[]{"mkfifo", "-m", "0" + modeStr, filename});
            LOG.info((Object)("mkfifo output:\n" + output));
        }
        this.fifoFile.deleteOnExit();
    }
}

