/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import com.cloudera.sqoop.util.ExportException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HsqldbManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)HsqldbManager.class.getName());
    private static final String DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private static final String HSQL_SCHEMA_NAME = "PUBLIC";

    public HsqldbManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
    }

    @Override
    public String[] listDatabases() {
        String[] databases = new String[]{HSQL_SCHEMA_NAME};
        return databases;
    }

    @Override
    public String escapeTableName(String tableName) {
        return '\"' + tableName + '\"';
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP FROM INFORMATION_SCHEMA.SYSTEM_TABLES";
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.getOptions().getConf().setInt("sqoop.export.records.per.statement", 1);
        super.exportTable(context);
    }
}

