import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine
from datetime import datetime, timedelta

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    # date_info = date.today().strftime("%Y-%m-%d")
    # last_date_info = (date.today() - timedelta(days=1)).strftime("%Y-%m-%d")
    last_date_info = (datetime.strptime(date_info, "%Y-%m-%d").date() - timedelta(days=1)).strftime("%Y-%m-%d")

    db_type = 'postgresql_cluster'
    import_table = f"{site_name}_keepa_last_detail"
    hive_table = "ods_keepa_asin_detail"
    partition_dict = {
        "site_name": site_name,
        "date_info": date_info
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    query = f"""
    SELECT asin, last_detail::text as last_detail, update_at FROM {import_table} 
    WHERE update_at >= '{last_date_info}' AND update_at < '{date_info}' AND last_detail is not null AND \$CONDITIONS
    """

    engine.sqoop_raw_import(
        query=query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict
    )

    pass
