/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.metastore.hsqldb;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.metastore.JobStorage;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class HsqldbJobStorage
extends JobStorage {
    public static final Log LOG = LogFactory.getLog((String)HsqldbJobStorage.class.getName());
    public static final String META_CONNECT_KEY = "metastore.connect.string";
    public static final String META_USERNAME_KEY = "metastore.username";
    public static final String META_PASSWORD_KEY = "metastore.password";
    private static final String DEFAULT_ROOT_TABLE_NAME = "SQOOP_ROOT";
    public static final String ROOT_TABLE_NAME_KEY = "sqoop.hsqldb.root.table.name";
    private static final String STORAGE_VERSION_KEY = "sqoop.hsqldb.job.storage.version";
    private static final int CUR_STORAGE_VERSION = 0;
    private static final String SESSION_TABLE_KEY = "sqoop.hsqldb.job.info.table";
    private static final String DEFAULT_SESSION_TABLE_NAME = "SQOOP_SESSIONS";
    private static final String PROPERTY_SET_KEY = "sqoop.property.set.id";
    private static final String CUR_PROPERTY_SET_ID = "0";
    private static final String PROPERTY_CLASS_SCHEMA = "schema";
    private static final String PROPERTY_CLASS_SQOOP_OPTIONS = "SqoopOptions";
    private static final String PROPERTY_CLASS_CONFIG = "config";
    private static final String SQOOP_TOOL_KEY = "sqoop.tool";
    private Map<String, String> connectedDescriptor;
    private String metastoreConnectStr;
    private String metastoreUser;
    private String metastorePassword;
    private Connection connection;
    private String jobTableName;
    private static final String DB_DRIVER_CLASS = "org.hsqldb.jdbcDriver";

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setMetastoreConnectStr(String connectStr) {
        this.metastoreConnectStr = connectStr;
    }

    protected void setMetastoreUser(String user) {
        this.metastoreUser = user;
    }

    protected void setMetastorePassword(String pass) {
        this.metastorePassword = pass;
    }

    protected void setConnectedDescriptor(Map<String, String> descriptor) {
        this.connectedDescriptor = descriptor;
    }

    @Override
    public void open(Map<String, String> descriptor) throws IOException {
        this.setMetastoreConnectStr(descriptor.get(META_CONNECT_KEY));
        this.setMetastoreUser(descriptor.get(META_USERNAME_KEY));
        this.setMetastorePassword(descriptor.get(META_PASSWORD_KEY));
        this.setConnectedDescriptor(descriptor);
        this.init();
    }

    protected void init() throws IOException {
        try {
            Class.forName(DB_DRIVER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load HSQLDB JDBC driver", cnfe);
        }
        try {
            this.connection = null == this.metastoreUser ? DriverManager.getConnection(this.metastoreConnectStr) : DriverManager.getConnection(this.metastoreConnectStr, this.metastoreUser, this.metastorePassword);
            this.connection.setTransactionIsolation(8);
            this.connection.setAutoCommit(false);
            if (!this.rootTableExists()) {
                this.createRootTable();
            }
            String curStorageVerStr = this.getRootProperty(STORAGE_VERSION_KEY, null);
            int actualStorageVer = -1;
            try {
                actualStorageVer = Integer.valueOf(curStorageVerStr);
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("Could not interpret as a number: " + curStorageVerStr));
            }
            if (actualStorageVer != 0) {
                LOG.error((Object)"Can not interpret metadata schema");
                LOG.error((Object)("The metadata schema version is " + curStorageVerStr));
                LOG.error((Object)"The highest version supported is 0");
                LOG.error((Object)"To use this version of Sqoop, you must downgrade your metadata schema.");
                throw new IOException("Invalid metadata version.");
            }
            this.initV0Schema();
        }
        catch (SQLException sqle) {
            if (null != this.connection) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e2) {
                    LOG.warn((Object)("Error rolling back transaction in error handler: " + e2));
                }
            }
            throw new IOException("Exception creating SQL connection", sqle);
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.connection) {
            try {
                LOG.debug((Object)"Flushing current transaction");
                this.connection.commit();
            }
            catch (SQLException sqlE) {
                throw new IOException("Exception committing connection", sqlE);
            }
            try {
                LOG.debug((Object)"Closing connection");
                this.connection.close();
            }
            catch (SQLException sqlE) {
                throw new IOException("Exception closing connection", sqlE);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public boolean canAccept(Map<String, String> descriptor) {
        return descriptor.get(META_CONNECT_KEY) != null;
    }

    @Override
    public JobData read(String jobName) throws IOException {
        try {
            String toolName;
            if (!this.jobExists(jobName)) {
                LOG.error((Object)("Cannot restore job: " + jobName));
                LOG.error((Object)"(No such job)");
                throw new IOException("Cannot restore missing job " + jobName);
            }
            LOG.debug((Object)("Restoring job: " + jobName));
            Properties schemaProps = this.getV0Properties(jobName, PROPERTY_CLASS_SCHEMA);
            Properties sqoopOptProps = this.getV0Properties(jobName, PROPERTY_CLASS_SQOOP_OPTIONS);
            Properties configProps = this.getV0Properties(jobName, PROPERTY_CLASS_CONFIG);
            String thisPropSetId = schemaProps.getProperty(PROPERTY_SET_KEY);
            LOG.debug((Object)"System property set: 0");
            LOG.debug((Object)("Stored property set: " + thisPropSetId));
            if (!CUR_PROPERTY_SET_ID.equals(thisPropSetId)) {
                LOG.warn((Object)"The property set present in this database was written by");
                LOG.warn((Object)"an incompatible version of Sqoop. This may result in an");
                LOG.warn((Object)"incomplete operation.");
            }
            if (null == (toolName = schemaProps.getProperty(SQOOP_TOOL_KEY))) {
                throw new IOException("Incomplete metadata; missing sqoop.tool");
            }
            SqoopTool tool = SqoopTool.getTool(toolName);
            if (null == tool) {
                throw new IOException("Error in job metadata: invalid tool " + toolName);
            }
            Configuration conf = new Configuration();
            for (Map.Entry<Object, Object> entry : configProps.entrySet()) {
                conf.set(entry.getKey().toString(), entry.getValue().toString());
            }
            SqoopOptions opts = new SqoopOptions();
            opts.setConf(conf);
            opts.loadProperties(sqoopOptProps);
            opts.setJobName(jobName);
            opts.setStorageDescriptor(this.connectedDescriptor);
            return new JobData(opts, tool);
        }
        catch (SQLException sqlE) {
            throw new IOException("Error communicating with database", sqlE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jobExists(String jobName) throws SQLException {
        PreparedStatement s = this.connection.prepareStatement("SELECT COUNT(job_name) FROM " + this.jobTableName + " WHERE job_name = ? GROUP BY job_name");
        ResultSet rs = null;
        try {
            s.setString(1, jobName);
            rs = s.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Error closing result set: " + sqlE));
                }
            }
            s.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String jobName) throws IOException {
        block8: {
            try {
                if (!this.jobExists(jobName)) {
                    LOG.error((Object)("No such job: " + jobName));
                    break block8;
                }
                LOG.debug((Object)("Deleting job: " + jobName));
                PreparedStatement s = this.connection.prepareStatement("DELETE FROM " + this.jobTableName + " WHERE job_name = ?");
                try {
                    s.setString(1, jobName);
                    s.executeUpdate();
                }
                finally {
                    s.close();
                }
                this.connection.commit();
            }
            catch (SQLException sqlEx) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e2) {
                    LOG.warn((Object)("Error rolling back transaction in error handler: " + e2));
                }
                throw new IOException("Error communicating with database", sqlEx);
            }
        }
    }

    @Override
    public void create(String jobName, JobData data) throws IOException {
        try {
            if (this.jobExists(jobName)) {
                LOG.error((Object)("Cannot create job " + jobName + ": it already exists"));
                throw new IOException("Job " + jobName + " already exists");
            }
        }
        catch (SQLException sqlE) {
            throw new IOException("Error communicating with database", sqlE);
        }
        this.createInternal(jobName, data);
    }

    private void createInternal(String jobName, JobData data) throws IOException {
        try {
            LOG.debug((Object)("Creating job: " + jobName));
            this.setV0Property(jobName, PROPERTY_CLASS_SCHEMA, SQOOP_TOOL_KEY, data.getSqoopTool().getToolName());
            this.setV0Property(jobName, PROPERTY_CLASS_SCHEMA, PROPERTY_SET_KEY, CUR_PROPERTY_SET_ID);
            Properties props = data.getSqoopOptions().writeProperties();
            this.setV0Properties(jobName, PROPERTY_CLASS_SQOOP_OPTIONS, props);
            Configuration saveConf = data.getSqoopOptions().getConf();
            Configuration baseConf = new Configuration();
            for (Map.Entry entry : saveConf) {
                String key = (String)entry.getKey();
                String rawVal = saveConf.getRaw(key);
                String baseVal = baseConf.getRaw(key);
                if (baseVal != null && rawVal.equals(baseVal)) continue;
                LOG.debug((Object)("Saving " + key + " => " + rawVal + " / " + baseVal));
                this.setV0Property(jobName, PROPERTY_CLASS_CONFIG, key, rawVal);
            }
            this.connection.commit();
        }
        catch (SQLException sqlE) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sqlE2) {
                LOG.warn((Object)("Exception rolling back transaction during error handling: " + sqlE2));
            }
            throw new IOException("Error communicating with database", sqlE);
        }
    }

    @Override
    public void update(String jobName, JobData data) throws IOException {
        try {
            if (!this.jobExists(jobName)) {
                LOG.error((Object)("Cannot update job " + jobName + ": not found"));
                throw new IOException("Job " + jobName + " does not exist");
            }
        }
        catch (SQLException sqlE) {
            throw new IOException("Error communicating with database", sqlE);
        }
        this.createInternal(jobName, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list() throws IOException {
        ArrayList<String> arrayList;
        PreparedStatement s;
        block13: {
            ResultSet rs = null;
            s = this.connection.prepareStatement("SELECT DISTINCT job_name FROM " + this.jobTableName);
            try {
                rs = s.executeQuery();
                ArrayList<String> jobs = new ArrayList<String>();
                while (rs.next()) {
                    jobs.add(rs.getString(1));
                }
                arrayList = jobs;
                if (null == rs) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqlE) {
                            LOG.warn((Object)("Error closing resultset: " + sqlE));
                        }
                    }
                    if (null != s) {
                        s.close();
                    }
                    throw throwable;
                }
                catch (SQLException sqlE) {
                    throw new IOException("Error communicating with database", sqlE);
                }
            }
            try {
                rs.close();
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Error closing resultset: " + sqlE));
            }
        }
        if (null != s) {
            s.close();
        }
        return arrayList;
    }

    private String getRootTableName() {
        Configuration conf = this.getConf();
        return conf.get(ROOT_TABLE_NAME_KEY, DEFAULT_ROOT_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(String table) throws SQLException {
        LOG.debug((Object)("Checking for table: " + table));
        DatabaseMetaData dbmd = this.connection.getMetaData();
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet rs = dbmd.getTables(null, null, null, tableTypes);
        if (null != rs) {
            try {
                while (rs.next()) {
                    if (!table.equalsIgnoreCase(rs.getString("TABLE_NAME"))) continue;
                    LOG.debug((Object)("Found table: " + table));
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                rs.close();
            }
        }
        LOG.debug((Object)"Could not find table.");
        return false;
    }

    private boolean rootTableExists() throws SQLException {
        String rootTableName = this.getRootTableName();
        return this.tableExists(rootTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRootTable() throws SQLException {
        String rootTableName = this.getRootTableName();
        LOG.debug((Object)("Creating root table: " + rootTableName));
        Statement s = this.connection.createStatement();
        try {
            s.executeUpdate("CREATE TABLE " + rootTableName + " (" + "version INT, " + "propname VARCHAR(128) NOT NULL, " + "propval VARCHAR(256), " + "CONSTRAINT " + rootTableName + "_unq UNIQUE (version, propname))");
        }
        finally {
            s.close();
        }
        this.setRootProperty(STORAGE_VERSION_KEY, null, Integer.toString(0));
        LOG.debug((Object)"Saving root table.");
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRootProperty(String propertyName, Integer version) throws SQLException {
        LOG.debug((Object)("Looking up property " + propertyName + " for version " + version));
        Statement s = null;
        ResultSet rs = null;
        try {
            if (null == version) {
                s = this.connection.prepareStatement("SELECT propval FROM " + this.getRootTableName() + " WHERE version IS NULL AND propname = ?");
                s.setString(1, propertyName);
            } else {
                s = this.connection.prepareStatement("SELECT propval FROM " + this.getRootTableName() + " WHERE version = ? " + " AND propname = ?");
                s.setInt(1, version);
                s.setString(2, propertyName);
            }
            rs = s.executeQuery();
            if (!rs.next()) {
                LOG.debug((Object)" => (no result)");
                String string = null;
                return string;
            }
            String result = rs.getString(1);
            LOG.debug((Object)(" => " + result));
            String string = result;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Error closing resultset: " + sqlE));
                }
            }
            if (null != s) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRootProperty(String propertyName, Integer version, String val) throws SQLException {
        LOG.debug((Object)("Setting property " + propertyName + " for version " + version + " => " + val));
        String curVal = this.getRootProperty(propertyName, version);
        PreparedStatement s = null == curVal ? this.connection.prepareStatement("INSERT INTO " + this.getRootTableName() + " (propval, propname, version) VALUES ( ? , ? , ? )") : (version == null ? this.connection.prepareStatement("UPDATE " + this.getRootTableName() + " SET propval = ? WHERE  propname = ? AND version IS NULL") : this.connection.prepareStatement("UPDATE " + this.getRootTableName() + " SET propval = ? WHERE  propname = ? AND version = ?"));
        try {
            s.setString(1, val);
            s.setString(2, propertyName);
            if (null != version) {
                s.setInt(3, version);
            }
            s.executeUpdate();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJobTable() throws SQLException {
        String curTableName = DEFAULT_SESSION_TABLE_NAME;
        int tableNum = -1;
        while (this.tableExists(curTableName)) {
            curTableName = "SQOOP_SESSIONS_" + ++tableNum;
        }
        LOG.debug((Object)("Creating job storage table: " + curTableName));
        Statement s = this.connection.createStatement();
        try {
            s.executeUpdate("CREATE TABLE " + curTableName + " (" + "job_name VARCHAR(64) NOT NULL, " + "propname VARCHAR(128) NOT NULL, " + "propval VARCHAR(1024), " + "propclass VARCHAR(32) NOT NULL, " + "CONSTRAINT " + curTableName + "_unq UNIQUE " + "(job_name, propname, propclass))");
            this.setRootProperty(SESSION_TABLE_KEY, 0, curTableName);
            this.connection.commit();
        }
        finally {
            s.close();
        }
        this.jobTableName = curTableName;
    }

    private void initV0Schema() throws SQLException {
        this.jobTableName = this.getRootProperty(SESSION_TABLE_KEY, 0);
        if (null == this.jobTableName) {
            this.createJobTable();
        }
        if (!this.tableExists(this.jobTableName)) {
            LOG.debug((Object)("Could not find job table: " + this.jobTableName));
            this.createJobTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setV0Property(String jobName, String propClass, String propName, String propVal) throws SQLException {
        LOG.debug((Object)("Job: " + jobName + "; Setting property " + propName + " with class " + propClass + " => " + propVal));
        Statement s = null;
        try {
            String curValue = this.getV0Property(jobName, propClass, propName);
            s = null == curValue ? this.connection.prepareStatement("INSERT INTO " + this.jobTableName + " (propval, job_name, propclass, propname) " + "VALUES (?, ?, ?, ?)") : this.connection.prepareStatement("UPDATE " + this.jobTableName + " SET propval = ? WHERE job_name = ? AND propclass = ? " + "AND propname = ?");
            s.setString(1, propVal);
            s.setString(2, jobName);
            s.setString(3, propClass);
            s.setString(4, propName);
            s.executeUpdate();
        }
        finally {
            if (null != s) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getV0Property(String jobName, String propClass, String propertyName) throws SQLException {
        LOG.debug((Object)("Job: " + jobName + "; Getting property " + propertyName + " with class " + propClass));
        ResultSet rs = null;
        PreparedStatement s = this.connection.prepareStatement("SELECT propval FROM " + this.jobTableName + " WHERE job_name = ? AND propclass = ? AND propname = ?");
        try {
            s.setString(1, jobName);
            s.setString(2, propClass);
            s.setString(3, propertyName);
            rs = s.executeQuery();
            if (!rs.next()) {
                LOG.debug((Object)" => (no result)");
                String string = null;
                return string;
            }
            String result = rs.getString(1);
            LOG.debug((Object)(" => " + result));
            String string = result;
            return string;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Error closing resultset: " + sqlE));
                }
            }
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getV0Properties(String jobName, String propClass) throws SQLException {
        LOG.debug((Object)("Job: " + jobName + "; Getting properties with class " + propClass));
        ResultSet rs = null;
        PreparedStatement s = this.connection.prepareStatement("SELECT propname, propval FROM " + this.jobTableName + " WHERE job_name = ? AND propclass = ?");
        try {
            s.setString(1, jobName);
            s.setString(2, propClass);
            rs = s.executeQuery();
            Properties p = new Properties();
            while (rs.next()) {
                p.setProperty(rs.getString(1), rs.getString(2));
            }
            Properties properties = p;
            return properties;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("Error closing result set: " + sqlE));
                }
            }
            s.close();
        }
    }

    private void setV0Properties(String jobName, String propClass, Properties properties) throws SQLException {
        LOG.debug((Object)("Job: " + jobName + "; Setting bulk properties for class " + propClass));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            this.setV0Property(jobName, propClass, key, val);
        }
    }
}

