import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.spark_util import SparkUtil
from pyspark.sql import functions as F
from utils.db_util import DBUtil

if __name__ == '__main__':
    spark = SparkUtil.get_spark_session("export_brand_black_to_mysql")

    # 品牌黑名单列表
    df_brand_black = spark.read.text("hdfs://hadoop15:8020/home/big_data_selection/tmp/brand_black.txt")
    df_brand_black = df_brand_black.withColumnRenamed(
        "value", "character_name"
    ).withColumn(
        'character_name', F.lower(F.trim('character_name'))
    ).drop_duplicates(['character_name'])

    df_save = df_brand_black.withColumn(
        'match_type', F.lit('品牌词库黑名单')
    )
    print("黑名单品牌词如下：")
    df_save.show(10)
    print("黑名单品牌词数：")
    print(df_save.count())

    con_info = DBUtil.get_connection_info("mysql", "us")
    df_save.write.format("jdbc") \
        .option("url", con_info["url"]) \
        .option("dbtable", "match_character_dict") \
        .option("user", con_info["username"]) \
        .option("password", con_info["pwd"]) \
        .mode("append") \
        .save()
