/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.netezza;

import com.cloudera.sqoop.config.ConfigurationHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.netezza.NetezzaExternalTableInputSplit;

public class NetezzaExternalTableInputFormat
extends InputFormat<Integer, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)NetezzaExternalTableInputFormat.class.getName());

    public RecordReader<Integer, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new NetezzaExternalTableRecordReader(split);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        int targetNumTasks = ConfigurationHelper.getJobNumMaps(context);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(targetNumTasks);
        for (int i = 0; i < targetNumTasks; ++i) {
            splits.add(new NetezzaExternalTableInputSplit(i));
        }
        return splits;
    }

    public static class NetezzaExternalTableRecordReader
    extends RecordReader<Integer, NullWritable> {
        private boolean delivered;
        private InputSplit split;

        public NetezzaExternalTableRecordReader(InputSplit split) {
            this.initialize(split, null);
        }

        public boolean nextKeyValue() {
            boolean hasNext = !this.delivered;
            this.delivered = true;
            return hasNext;
        }

        public Integer getCurrentKey() {
            return ((NetezzaExternalTableInputSplit)this.split).getDataSliceId();
        }

        public NullWritable getCurrentValue() {
            return NullWritable.get();
        }

        public void close() {
        }

        public float getProgress() {
            return this.delivered ? 1.0f : 0.0f;
        }

        public void initialize(InputSplit s, TaskAttemptContext context) {
            this.split = s;
            this.delivered = false;
        }
    }
}

