import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    print(f"执行参数为{sys.argv}")

    # 获取数据库引擎
    db_type = "postgresql_15"
    engine = get_remote_engine(
        site_name='us',
        db_type=db_type
    )
    if site_name == 'us':
        export_tb = f"ai_asin_detail_month_{date_info.replace('-', '_')}"
    else:
        export_tb = f"{site_name}_ai_asin_detail_month_{date_info.replace('-', '_')}"

    # 导出数据
    engine.sqoop_raw_export(
        hive_table="dwt_ai_asin_add",
        import_table=export_tb,
        partitions={
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        },
        m=30,
        cols="site_name,asin,weight,bought_month,category,img,title,brand,account_name,account_addr,buy_box_seller_type,"
             "launch_time,img_num,variation_flag,variation_num,ao_val,category_id,category_current_id,parent_asin,bsr_rank,"
             "price,rating,total_comments,seller_id,fb_country_name,review_json_list,launch_time_type,describe,product_json,"
             "product_detail_json,bought_month_mom,bought_month_yoy,is_new_flag,is_ascending_flag"
    )

    print("success")
