import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine
from datetime import datetime, timedelta

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    last_date_info = (datetime.strptime(date_info, "%Y-%m-%d").date() - timedelta(days=1)).strftime("%Y-%m-%d")

    db_type = 'postgresql_cluster'
    hive_table = "dim_asin_profit_rate_info"
    partition_dict = {
        "site_name": site_name,
        "date_info": date_info
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    query = f"""
    select asin, price, category, ocean_profit, air_profit, package_length, package_width, package_height, weight, updated_time 
    from {site_name}_asin_profit_rate_calc where calc_flag = 1 and updated_time >= '{last_date_info}' and updated_time < '{date_info}' and \$CONDITIONS
    """
    engine.sqoop_raw_import(
        query=query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        check_count=False
    )

    print('success！')
