import json

from utils.datahub_util import build_column_lineages

to_tb = "dwt_aba_last365"
sources = [
    {
        "form": "dwt_aba_st_analytics",
        "mappings": [
            ("id", "id"),
            ("search_term", "search_term"),
            ("category_id", "category_id"),
            ("st_num", "st_num1"),
            ("st_num", "st_num2"),
            ("st_num", "st_num3"),
            ("st_num", "st_num4"),
            ("st_num", "st_num5"),
            ("st_num", "st_num6"),
            ("st_num", "st_num7"),
            ("st_num", "st_num8"),
            ("st_num", "st_num9"),
            ("st_num", "st_num10"),
            ("st_num", "st_num11"),
            ("st_num", "st_num12"),
            ("form", "total_st_num"),
            ("bsr_orders", "bsr_orders1"),
            ("bsr_orders", "bsr_orders2"),
            ("bsr_orders", "bsr_orders3"),
            ("bsr_orders", "bsr_orders4"),
            ("bsr_orders", "bsr_orders5"),
            ("bsr_orders", "bsr_orders6"),
            ("bsr_orders", "bsr_orders7"),
            ("bsr_orders", "bsr_orders8"),
            ("bsr_orders", "bsr_orders9"),
            ("bsr_orders", "bsr_orders10"),
            ("bsr_orders", "bsr_orders11"),
            ("bsr_orders", "bsr_orders12"),
            ("market_cycle_type", "market_cycle_type1"),
            ("market_cycle_type", "market_cycle_type2"),
            ("market_cycle_type", "market_cycle_type3"),
            ("market_cycle_type", "market_cycle_type4"),
            ("market_cycle_type", "market_cycle_type5"),
            ("market_cycle_type", "market_cycle_type6"),
            ("market_cycle_type", "market_cycle_type7"),
            ("market_cycle_type", "market_cycle_type8"),
            ("market_cycle_type", "market_cycle_type9"),
            ("market_cycle_type", "market_cycle_type10"),
            ("market_cycle_type", "market_cycle_type11"),
            ("market_cycle_type", "market_cycle_type12"),
            ("search_volume", "search_volume1"),
            ("search_volume", "search_volume2"),
            ("search_volume", "search_volume3"),
            ("search_volume", "search_volume4"),
            ("search_volume", "search_volume5"),
            ("search_volume", "search_volume6"),
            ("search_volume", "search_volume7"),
            ("search_volume", "search_volume8"),
            ("search_volume", "search_volume9"),
            ("search_volume", "search_volume10"),
            ("search_volume", "search_volume11"),
            ("search_volume", "search_volume12"),
            ("st_ao_avg", "st_ao_avg"),
            ("st_ao_val_rate", "st_ao_val_rate"),
            ("supply_demand", "supply_demand"),
            ("price_avg", "price_avg"),
            ("total_comments_avg", "total_comments_avg"),
            ("rating_avg", "rating_avg"),
            ("weight_avg", "weight_avg"),
            ("volume_avg", "volume_avg"),
            ("aadd_proportion", "aadd_proportion"),
            ("sp_proportion", "sp_proportion"),
            ("fbm_proportion", "fbm_proportion"),
            ("cn_proportion", "cn_proportion"),
            ("amzon_proportion", "amzon_proportion"),
            ("top3_seller_orders", "top3_seller_orders"),
            ("top3_seller_bsr_orders", "top3_seller_bsr_orders"),
            ("top3_brand_orders", "top3_brand_orders"),
            ("top3_brand_bsr_orders", "top3_brand_bsr_orders"),
            ("page3_brand_num", "page3_brand_num"),
            ("page3_seller_num", "page3_seller_num"),
            ("max_num", "max_num"),
            ("most_proportion", "most_avg_proportion"),
            ("new_asin_proportion", "new_asin_num_avg_monopoly"),
            ("new_bsr_orders_proportion", "new_asin_bsr_orders_avg_monopoly"),
            ("total_asin_num", "total_asin_num"),
            # ("form", "orders"),
            ("bsr_orders", "bsr_orders"),
            ("max_num_asin", "max_num_asin"),
            ("is_self_max_num_asin", "is_self_max_num_asin"),

            ("gross_profit_fee_sea", "gross_profit_fee_sea"),
            ("gross_profit_fee_air", "gross_profit_fee_air"),
            ("category_current_id", "category_current_id"),
            ("color_proportion", "color_proportion"),
            ("brand_monopoly", "brand_monopoly"),
            ("seller_monopoly", "seller_monopoly"),
            # ("form", "top_rank"),
            # ("form", "orders1"),
            # ("form", "orders2"),
            # ("form", "orders3"),
            # ("form", "orders4"),
            # ("form", "orders5"),
            # ("form", "orders6"),
            # ("form", "orders7"),
            # ("form", "orders8"),
            # ("form", "orders9"),
            # ("form", "orders10"),
            # ("form", "orders11"),
            # ("form", "orders12"),
            # ("form", "max_orders_month"),
            # ("form", "max_bsr_orders_month"),
            ("multi_color_proportion", "multi_color_avg_proportion"),
            ("multi_size_proportion", "multi_size_avg_proportion"),
            # ("form", "q1_bsr_orders"),
            # ("form", "q2_bsr_orders"),
            # ("form", "q3_bsr_orders"),
            # ("form", "q4_bsr_orders"),
            # ("form", "q1_orders"),
            # ("form", "q2_orders"),
            # ("form", "q3_orders"),
            # ("form", "q4_orders"),
            # ("form", "is_new_market_segment"),
            # ("form", "is_first_text"),
            # ("form", "is_ascending_text"),
            # ("form", "is_search_text"),
            ("st_word_num", "st_word_num"),
            # ("form", "site_name"),
            # ("form", "date_type"),
            # ("form", "date_info"),
        ]
    },

    {
        "form": "dwt_st_sv_last365",
        "mappings": [
            ("sv_rank", "rank"),
        ]
    },

    {
        "form": "dim_st_detail",
        "mappings": [
            ("st_search_sum", "orders"),
        ]
    }
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
