from flask import Flask, render_template, Blueprint

from app.models.Resp import Resp

exception = Blueprint('exception', __name__)

"""
全局异常处理
"""


@exception.app_errorhandler(500)
def server_error(error):
    return Resp.err(str(error))


@exception.app_errorhandler(AssertionError)
def handle_assertion_error(error):
    return Resp.err(error.args[0])


@exception.app_errorhandler(Exception)
def all_error(error):
    return Resp.err(str(error))
