import os
import sys

os.environ["PYARROW_IGNORE_TIMEZONE"] = "1"
sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.templates import Templates
# from ..utils.templates import Templates


class PicturesIdIndexCopy(Templates):

    def __init__(self, site_name='us'):
        super(PicturesIdIndexCopy, self).__init__()
        self.site_name = site_name
        self.db_save = f'pictures_dwd_id_index_copy'
        self.spark = self.create_spark_object(app_name=f"{self.db_save}: {self.site_name}")
        self.df_save = self.spark.sql(f"select 1+1;")
        self.partitions_by = ['site_name']
        self.partitions_num = 1000

    def read_data(self):
        sql = f"select * from pictures_dwd_id_index where site_name='{self.site_name}';"
        print("sql:", sql)
        self.df_save = self.spark.sql(sql).cache()


if __name__ == '__main__':
    site_name = sys.argv[1]
    handle_obj = PicturesIdIndexCopy(site_name=site_name)
    handle_obj.run()