/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.sqoop.mapreduce.DataDrivenImportJob;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetImportMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputFormat;

public class MainframeImportJob
extends DataDrivenImportJob {
    private static final Log LOG = LogFactory.getLog((String)MainframeImportJob.class.getName());

    public MainframeImportJob(SqoopOptions opts, ImportJobContext context) {
        super(opts, MainframeDatasetInputFormat.class, context);
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return MainframeDatasetImportMapper.class;
        }
        return super.getMapperClass();
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws IOException {
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        job.getConfiguration().set("mapreduce.mainframe.input.dataset.name", this.options.getMainframeInputDatasetName());
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        super.configureOutputFormat(job, tableName, tableClassName);
        LazyOutputFormat.setOutputFormatClass((Job)job, this.getOutputFormatClass());
    }
}

