/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.tool.ImportTool;

public class MainframeImportTool
extends ImportTool {
    private static final Log LOG = LogFactory.getLog((String)MainframeImportTool.class.getName());
    public static final String DS_ARG = "dataset";

    public MainframeImportTool() {
        super("import-mainframe", false);
    }

    @Override
    protected RelatedOptions getImportOptions() {
        RelatedOptions importOpts = new RelatedOptions("Import mainframe control arguments");
        OptionBuilder.withArgName((String)"Dataset name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Datasets to import");
        OptionBuilder.withLongOpt((String)DS_ARG);
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data in delete mode");
        OptionBuilder.withLongOpt((String)"delete-target-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS plain file destination");
        OptionBuilder.withLongOpt((String)"target-dir");
        importOpts.addOption(OptionBuilder.create());
        this.addValidationOpts(importOpts);
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HDFS parent for file destination");
        OptionBuilder.withLongOpt((String)"warehouse-dir");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Imports data as plain text (default)");
        OptionBuilder.withLongOpt((String)"as-textfile");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use 'n' map tasks to import in parallel");
        OptionBuilder.withLongOpt((String)"num-mappers");
        importOpts.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set name for generated mapreduce job");
        OptionBuilder.withLongOpt((String)"mapreduce-job-name");
        importOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Enable compression");
        OptionBuilder.withLongOpt((String)"compress");
        importOpts.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"codec");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Compression codec to use for import");
        OptionBuilder.withLongOpt((String)"compression-codec");
        importOpts.addOption(OptionBuilder.create());
        return importOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        toolOptions.addUniqueOptions(this.getImportOptions());
        toolOptions.addUniqueOptions(this.getOutputFormatOptions());
        toolOptions.addUniqueOptions(this.getInputFormatOptions());
        toolOptions.addUniqueOptions(this.getHiveOptions(true));
        toolOptions.addUniqueOptions(this.getHBaseOptions());
        toolOptions.addUniqueOptions(this.getHCatalogOptions());
        toolOptions.addUniqueOptions(this.getHCatImportOnlyOptions());
        toolOptions.addUniqueOptions(this.getAccumuloOptions());
        RelatedOptions codeGenOpts = this.getCodeGenOpts(false);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Disable code generation; use specified jar");
        OptionBuilder.withLongOpt((String)"jar-file");
        codeGenOpts.addOption(OptionBuilder.create());
        toolOptions.addUniqueOptions(codeGenOpts);
    }

    @Override
    public void printHelp(ToolOptions toolOptions) {
        System.out.println("usage: sqoop " + this.getToolName() + " [GENERIC-ARGS] [TOOL-ARGS]\n");
        toolOptions.printHelp();
        System.out.println("\nGeneric Hadoop command-line arguments:");
        System.out.println("(must preceed any tool-specific arguments)");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        System.out.println("\nAt minimum, you must specify --connect and --dataset");
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        super.applyOptions(in, out);
        if (!in.hasOption("connection-manager")) {
            out.setConnManagerClassName("org.apache.sqoop.manager.MainframeManager");
        }
        if (in.hasOption(DS_ARG)) {
            out.setMainframeInputDatasetName(in.getOptionValue(DS_ARG));
        }
    }

    @Override
    protected void validateImportOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getMainframeInputDatasetName() == null) {
            throw new SqoopOptions.InvalidOptionsException("--dataset is required for mainframe import. \nTry --help for usage instructions.");
        }
        super.validateImportOptions(options);
    }
}

