import os
import sys
sys.path.append(os.path.dirname(sys.path[0]))
from utils.secure_db_client import get_remote_engine


engine = get_remote_engine(
    site_name="us",          # -> database "selection"
    db_type="postgresql_14",         # -> 服务端 alias "mysql"
)

site_name = 'us'
date_type = 'day'
date_info = '2026-02-04'
partitions = {
    'site_name': site_name,
    'date_type': date_type,
    'date_info': date_info,
}

cols_list = ['asin', 'asin_cate_flag', 'date_info']
engine.sqoop_raw_export(
    hive_table='dwd_nsr_bsr_keepa_asin',
    import_table=f'{site_name}_all_syn_st_day_{date_info.replace("-", "_")}',
    partitions=partitions,
    m=1,
    cols=','.join(cols_list)
)