/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TextImportMapper
extends AutoProgressMapper<LongWritable, SqoopRecord, Text, NullWritable> {
    private Text outkey = new Text();
    private LargeObjectLoader lobLoader;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.lobLoader = new LargeObjectLoader(context.getConfiguration(), FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context));
    }

    public void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            val.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        this.outkey.set(val.toString());
        context.write((Object)this.outkey, (Object)NullWritable.get());
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }
}

