import os
import sys
sys.path.append(os.path.dirname(sys.path[0]))
from utils.secure_db_client import get_remote_engine


engine = get_remote_engine(
    site_name="us",          # -> database "selection"
    db_type="postgresql_14",         # -> 服务端 alias "mysql"
)

site_name = sys.argv[1]  # 参数1：站点
date_type = sys.argv[2]  # 参数2：类型：day/week/4_week/month/quarter
date_info = sys.argv[3]  # 参数3：年-月-日/年-周/年-月/年-季, 比如: 2022-1

partitions = {
    'site_name': site_name,
    'date_type': date_type,
    'date_info': date_info,
}

cols_list = ['asin', 'asin_cate_flag', 'date_info']
import_table=f'{site_name}_all_syn_st_day_{date_info.replace("-", "_")}'
engine.execute(f"truncate {import_table};")
print(f"清空对应的pg14-asin导出表： {import_table}")
engine.sqoop_raw_export(
    hive_table='dwd_nsr_bsr_keepa_asin',
    import_table=import_table,
    partitions=partitions,
    m=1,
    cols=','.join(cols_list)
)