#! /bin/env bash

# author: 方星钧(ffman)
# description: 清洗6大站点对应的 单周的zr，sp，sb，ac，bs，er，tr等7大类型数据表（计算zr,sp类型表的page_rank+合并7张表）
# params: param1: site_name_array;param2: year; param3: week
# table_read_name: ods_brand_analytics
# table_save_name: dim_st_asin_base_info
# table_save_level: dim
# version: 1.0
# created_date: 2022-05-10
# updated_date: 2022-11-07

date_type=$2
date_info=$3
hive_table=dim_st_asin_info
hive_level=dim

if [ $1 == all ];
then
        site_name_array=(us uk de es fr it)
else
        site_name_array=($1)
fi

flag=1

for site_name in ${site_name_array[*]}
	do
		echo "site_name: ${site_name}","year: ${year}","week: ${week}"
		echo "hive_table: ${hive_table}"
		hdfs dfs -rm -r /home/big_data_selection/${hive_level}/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}/*
		# standAlone模式执行
		# /opt/module/spark/bin/spark-submit --master spark://hadoop1:7077 /opt/module/spark/demo/py_demo/dim/${hive_table}.py ${site_name} ${date_type} ${date_info}
		# 放到yarn执行
		/opt/module/spark/bin/spark-submit \
		--master yarn \
		--driver-memory 2g \
		--executor-memory 12g \
		--executor-cores 3 \
		--num-executors 20 \
		--queue spark \
		/mnt/Amazon-Selection/Pyspark_job/dim/${hive_level}/${hive_table}.py ${site_name} ${date_type} ${date_info}
	done

