#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi

date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`

for site_name in ${site_name_array[*]}
	do
		if [ $site_name == us ];
		then
			db=selection
		else
			db=selection_$site_name
		fi
		# 导入数据
		import_table=${site_name}_rank_search_rate_repeat
		hive_table=ods_rank_search_rate_repeat
		db_type=mysql
		hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}
		cols="id,rank,search_num,rate,rank_group,search_sum,created_time,updated_time"
		query="select ${cols} from ${import_table} where year=${d1} and month=${d2} and \$CONDITIONS"
		import_data	
	done
	
