import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.DolphinschedulerHelper import DolphinschedulerHelper
from utils.common_util import CommonUtil
from utils.spark_util import SparkUtil


if __name__ == '__main__':

    spark_session = SparkUtil.get_spark_session("rerun-dwt—flow-asin")
    date_list = ["2024-02","2024-01","2023-12"]
    for date_info in date_list:
        startParams = {
            "site_name": "us",
            "date_type": "month",
            "date_info": date_info
        }
        print(startParams)
        DolphinschedulerHelper.start_and_watch_process_instance(
            "big_data_selection",
            process_df_name='rerun_dwt_flow_asin_api',
            startParams={
                "site_name": "us",
                "date_type": "month",
                "date_info": date_info
            }
        )

    CommonUtil.send_wx_msg(["chenyuanjie"], "【rerun_dwt_flow_asin_api】重跑完成", "")

    pass
