import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.templates import Templates
# from ..utils.templates import Templates
from pyspark.sql.types import IntegerType
from utils.db_util import DbTypes, DBUtil

class GetAsinBsr1000(Templates):

    def __init__(self, site_name='us', date_type="month", date_info='2025-06'):
        super().__init__()
        self.site_name = site_name
        self.date_type = date_type
        self.date_info = date_info
        self.db_save = f'dim_get_asin_bsr1000'
        self.spark = self.create_spark_object(
            app_name=f"{self.db_save}: {self.site_name},{self.date_type}, {self.date_info}")
        self.engine_postgresql_14 = DBUtil.get_db_engine(db_type=DbTypes.postgresql_14.name, site_name=self.site_name)
        self.df_date = self.get_year_week_tuple()
        self.df_st_asin = self.spark.sql(f"select 1+1;")
        self.df_asin_measure = self.spark.sql(f"select 1+1;")
        self.df_save = self.spark.sql(f"select 1+1;")
        self.partitions_by = ['site_name', 'date_type', 'date_info']
        self.reset_partitions(partitions_num=10)

    def read_data(self):
        print("1.1 读取dim_st_asin_info表")
        sql = f"select distinct(asin) as asin from dim_st_asin_info where site_name='{self.site_name}' and date_type='{self.date_type}' and date_info ='{self.date_info}'"
        self.df_st_asin = self.spark.sql(sqlQuery=sql).cache()
        self.df_st_asin.show(10, truncate=False)
        print("1.2 读取dwd_asin_measure表")
        sql = f"select asin, asin_bsr_orders, date_info from dwd_asin_measure where site_name='{self.site_name}' and date_type='{self.date_type}' and date_info ='{self.date_info}' and asin_bsr_orders> 1000"
        self.df_asin_measure = self.spark.sql(sqlQuery=sql).cache()
        self.df_asin_measure.show(10, truncate=False)

    def handle_data(self):
        self.df_save = self.df_st_asin.join(
            self.df_asin_measure, on=['asin'], how='inner'
        )
        print(f"bsr月销量大于1000的asin数量为: {self.df_save.count()}")
        self.df_save.show(20, truncate=False)

    def save_data(self):
        df_save = self.df_save.toPandas()



if __name__ == '__main__':
    site_name = sys.argv[1]  # 参数1：站点
    date_type = sys.argv[2]  # 参数2：类型：week/4_week/month/quarter/day
    date_info = sys.argv[3]  # 参数3：年-周/年-月/年-季/年-月-日, 比如: 2022-1
    handle_obj = GetAsinBsr1000(site_name=site_name, date_type=date_type, date_info=date_info)
    handle_obj.run()
