/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.sqoop.mapreduce.AvroJob;

public class AvroOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    static <T> void configureDataFileWriter(DataFileWriter<T> writer, TaskAttemptContext context) throws UnsupportedEncodingException {
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            int level = context.getConfiguration().getInt("avro.mapred.deflate.level", 1);
            String codecName = context.getConfiguration().get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            writer.setCodec(factory);
        }
        writer.setSyncInterval(context.getConfiguration().getInt("avro.mapred.sync.interval", 16000));
        for (Map.Entry e : context.getConfiguration()) {
            if (((String)e.getKey()).startsWith("avro.meta.text.")) {
                writer.setMeta(((String)e.getKey()).substring("avro.meta.text.".length()), (String)e.getValue());
            }
            if (!((String)e.getKey()).startsWith("avro.meta.binary.")) continue;
            writer.setMeta(((String)e.getKey()).substring("avro.meta.binary.".length()), URLDecoder.decode((String)e.getValue(), "ISO-8859-1").getBytes("ISO-8859-1"));
        }
    }

    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        boolean isMapOnly = context.getNumReduceTasks() == 0;
        Schema schema = isMapOnly ? AvroJob.getMapOutputSchema(context.getConfiguration()) : AvroJob.getOutputSchema(context.getConfiguration());
        final DataFileWriter WRITER = new DataFileWriter((DatumWriter)new ReflectDatumWriter());
        AvroOutputFormat.configureDataFileWriter(WRITER, context);
        Path path = this.getDefaultWorkFile(context, ".avro");
        WRITER.create(schema, (OutputStream)path.getFileSystem(context.getConfiguration()).create(path));
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){

            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                WRITER.append(wrapper.datum());
            }

            public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                WRITER.close();
            }
        };
    }
}

