/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.mapreduce.MergeJob;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.util.LoggingUtils;

public class MergeTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)MergeTool.class.getName());

    public MergeTool() {
        this("merge");
    }

    public MergeTool(String toolName) {
        super(toolName);
    }

    @Override
    public int run(SqoopOptions options) {
        try {
            MergeJob mergeJob = new MergeJob(options);
            if (!mergeJob.runMergeJob()) {
                LOG.error((Object)"MapReduce job failed!");
                return 1;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Encountered IOException running import job: " + StringUtils.stringifyException((Throwable)ioe)));
            if (System.getProperty("sqoop.throwOnError") != null) {
                throw new RuntimeException(ioe);
            }
            return 1;
        }
        return 0;
    }

    protected RelatedOptions getMergeOptions() {
        RelatedOptions mergeOpts = new RelatedOptions("Merge arguments");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Load class from specified jar file");
        OptionBuilder.withLongOpt((String)"jar-file");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify record class name to load");
        OptionBuilder.withLongOpt((String)"class-name");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the more recent data set");
        OptionBuilder.withLongOpt((String)"new-data");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the older data set");
        OptionBuilder.withLongOpt((String)"onto");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Destination path for merged results");
        OptionBuilder.withLongOpt((String)"target-dir");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"column");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Key column to use to join results");
        OptionBuilder.withLongOpt((String)"merge-key");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Print more information while working");
        OptionBuilder.withLongOpt((String)"verbose");
        mergeOpts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Print usage instructions");
        OptionBuilder.withLongOpt((String)"help");
        mergeOpts.addOption(OptionBuilder.create());
        return mergeOpts;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getMergeOptions());
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        if (in.hasOption("verbose")) {
            LoggingUtils.setDebugLevel();
            LOG.debug((Object)"Enabled debug logging.");
        }
        if (in.hasOption("help")) {
            ToolOptions toolOpts = new ToolOptions();
            this.configureOptions(toolOpts);
            this.printHelp(toolOpts);
            throw new SqoopOptions.InvalidOptionsException("");
        }
        if (in.hasOption("jar-file")) {
            out.setExistingJarName(in.getOptionValue("jar-file"));
        }
        if (in.hasOption("class-name")) {
            out.setClassName(in.getOptionValue("class-name"));
        }
        if (in.hasOption("new-data")) {
            out.setMergeNewPath(in.getOptionValue("new-data"));
        }
        if (in.hasOption("onto")) {
            out.setMergeOldPath(in.getOptionValue("onto"));
        }
        if (in.hasOption("target-dir")) {
            out.setTargetDir(in.getOptionValue("target-dir"));
        }
        if (in.hasOption("merge-key")) {
            out.setMergeKeyCol(in.getOptionValue("merge-key"));
        }
    }

    protected void validateMergeOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (options.getMergeNewPath() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must set the new dataset path with --new-data.\nTry --help for usage instructions.");
        }
        if (options.getMergeOldPath() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must set the old dataset path with --onto.\nTry --help for usage instructions.");
        }
        if (options.getMergeKeyCol() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must set the merge key column with --merge-key.\nTry --help for usage instructions.");
        }
        if (options.getTargetDir() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must set the target directory with --target-dir.\nTry --help for usage instructions.");
        }
        if (options.getClassName() == null) {
            throw new SqoopOptions.InvalidOptionsException("Must set the SqoopRecord class implementation to use with --class-name.\nTry --help for usage instructions.");
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        options.setExtraArgs(this.getSubcommandArgs(this.extraArguments));
        int dashPos = this.getDashPosition(this.extraArguments);
        if (this.hasUnrecognizedArgs(this.extraArguments, 0, dashPos)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        this.validateMergeOptions(options);
    }
}

