#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh


if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi

if [ $2 == all ];
then
    st_type_array=(zr sp sb ac bs er tr)
else
    st_type_array=($2)
fi

date_type=$3
date_info=$4
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`


for site_name in ${site_name_array[*]}
	do
		if [ $site_name == us ];
		then
			db=selection
		else
			db=selection_$site_name
		fi
		for st_type in ${st_type_array[*]}
			do
				# 导入数据
				if [ $st_type == zr ]
				then
					cols="search_term,asin,page,page_row,created_time,updated_time"
				elif [ $st_type == sp ]
				then
					cols="search_term,asin,page,page_row,created_time,updated_time"
				elif [ $st_type == sb ]
				then
					cols="search_term,asin,page,data_type,created_time,updated_time"
				elif [ $st_type == tr ]
				then
					cols="search_term,asin,page,data_type,created_time,updated_time"
				else
					cols="search_term,asin,page,created_time,updated_time"
				fi
				
				if [ $date_type == 'day' ]
				then
					d3=`echo $date_info | cut -d \- -f 3`
					import_table=${site_name}_st_${st_type}_everyday_${d1}_${d2}_${d3}
					db_type=postgresql
				elif [ $date_type == 'week' ]
				then 
					import_table=${site_name}_search_term_rank_${st_type}_${d1}_$((d2))
					db_type=mysql
				else
					echo date_type: 输入错误
				fi
				query="select ${cols} from ${import_table} where 1=1 and \$CONDITIONS"
				#query="select ${cols} from ${import_table} where date_info='${date_info}' and \$CONDITIONS"
				echo cols:${cols}, date_type:${date_type}, query:${query}
				hive_table=ods_search_term_${st_type}
				hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}
				import_data
			done
	done


