import json

from utils.datahub_util import build_column_lineages

to_tb = "dim_fd_asin_info"
sources = [
    {
        "form": "ods_seller_account_syn",
        "mappings": [
            ("id", "fd_account_id"),
            ("account_name", "fd_account_name"),
        ]
    },
    {
        "form": "ods_seller_asin_account",
        "mappings": [
            ("account_name", "fd_account_name"),
            ("asin", "asin"),
        ]
    },
    {
        "form": "ods_seller_account_feedback",
        "mappings": [
            ("country_name", "fd_country_name"),
        ]
    },
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
