#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ]
then
    site_name_array=(uk de es fr it us)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
year=`echo $date_info | cut -d \- -f 1`
export_env=$4

# 根据export_env判断是否导出到PG测试环境
if [ $export_env == test ]
then
    db_type=pgsqltest
    echo "同步到测试库中"
else
    db_type=postgresql
    echo "同步到正式库中"
fi

for site_name in ${site_name_array[*]}
    do
		echo 1. 当前连接的数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导出数据
		if [ $date_type == day ]
		then
			month=`echo $date_info | cut -d \- -f 2`
			day=`echo $date_info | cut -d \- -f 3`
			import_table=${site_name}_aba_last_day_${year}_${month}_${day}
			truncate_table=${site_name}_aba_last_day_${year}_${month}_${day}
			cols="id,search_term,rank,category_id,category_current_id,orders,bsr_orders,search_volume,quantity_being_sold,st_ao_avg,st_ao_val_rate,new_bsr_orders_proportion,new_asin_proportion,page1_title_proportion,price_avg,total_comments_avg,rating_avg,weight_avg,volume_avg,title_length_avg,st_num,aadd_proportion,sp_proportion,fbm_proportion,cn_proportion,amzon_proportion,most_proportion,max_num,asin1,asin2,asin3,click_share1,click_share2,click_share3,total_click_share,conversion_share1,conversion_share2,conversion_share3,total_conversion_share,new_asin_num,total_asin_num,new_asin_orders,new_asin_bsr_orders,is_first_text,is_ascending_text,is_search_text,top3_seller_orders,top3_seller_bsr_orders,top3_brand_orders,top3_brand_bsr_orders,page3_brand_num,page3_seller_num,brand_monopoly,seller_monopoly,max_num_asin,is_self_max_num_asin,created_time,updated_time,date_info,gross_profit_fee_air,gross_profit_fee_sea,multi_color_proportion,multi_size_proportion,st_4_20_ao_avg"
		elif [ $date_type == week ]
		then
			week=`echo $date_info | cut -d \- -f 2`
			import_table=${site_name}_aba_last_week_${year}_${week}
			truncate_table=${site_name}_aba_last_week_${year}_${week}
			cols="id,search_term,rank,category_id,category_current_id,orders,bsr_orders,search_volume,quantity_being_sold,st_ao_avg,st_ao_val_rate,new_bsr_orders_proportion,new_asin_proportion,page1_title_proportion,price_avg,total_comments_avg,rating_avg,weight_avg,volume_avg,title_length_avg,st_num,aadd_proportion,sp_proportion,fbm_proportion,cn_proportion,amzon_proportion,most_proportion,max_num,asin1,asin2,asin3,click_share1,click_share2,click_share3,total_click_share,conversion_share1,conversion_share2,conversion_share3,total_conversion_share,new_asin_num,total_asin_num,new_asin_orders,new_asin_bsr_orders,is_first_text,is_ascending_text,is_search_text,top3_seller_orders,top3_seller_bsr_orders,top3_brand_orders,top3_brand_bsr_orders,page3_brand_num,page3_seller_num,brand_monopoly,seller_monopoly,max_num_asin,is_self_max_num_asin,is_new_market_segment,created_time,updated_time,date_info,color_proportion,gross_profit_fee_air,gross_profit_fee_sea,multi_color_proportion,multi_size_proportion,st_4_20_ao_avg"
		elif [ $date_type == month ]
		then
			month=`echo $date_info | cut -d \- -f 2`
			import_table=${site_name}_aba_last_month_${year}_${month}
			truncate_table=${site_name}_aba_last_month_${year}_${month}
			cols="id,search_term,rank,category_id,category_current_id,orders,bsr_orders,search_volume,quantity_being_sold,st_ao_avg,st_ao_val_rate,new_bsr_orders_proportion,new_asin_proportion,page1_title_proportion,price_avg,total_comments_avg,rating_avg,weight_avg,volume_avg,title_length_avg,st_num,aadd_proportion,sp_proportion,fbm_proportion,cn_proportion,amzon_proportion,most_proportion,max_num,asin1,asin2,asin3,click_share1,click_share2,click_share3,total_click_share,conversion_share1,conversion_share2,conversion_share3,total_conversion_share,new_asin_num,total_asin_num,new_asin_orders,new_asin_bsr_orders,is_first_text,is_ascending_text,is_search_text,top3_seller_orders,top3_seller_bsr_orders,top3_brand_orders,top3_brand_bsr_orders,page3_brand_num,page3_seller_num,brand_monopoly,seller_monopoly,max_num_asin,is_self_max_num_asin,is_new_market_segment,created_time,updated_time,date_info,supply_demand,market_cycle_type,color_proportion,gross_profit_fee_air,gross_profit_fee_sea,multi_color_proportion,multi_size_proportion,st_4_20_ao_avg,st_4_20_ao_rate"
		elif [ $date_type == last30day ]
		then
			month=`echo $date_info | cut -d \- -f 2`
			import_table=${site_name}_aba_last_30_day_copy
			truncate_table=${site_name}_aba_last_30_day_copy
			cols="id,rank,category_id,category_current_id,search_term,orders,bsr_orders,search_volume,quantity_being_sold,st_ao_avg,st_ao_val_rate,new_bsr_orders_proportion,new_asin_proportion,page1_title_proportion,price_avg,total_comments_avg,rating_avg,weight_avg,volume_avg,title_length_avg,st_num,aadd_proportion,sp_proportion,fbm_proportion,cn_proportion,amzon_proportion,most_proportion,max_num,asin1,asin2,asin3,click_share1,click_share2,click_share3,total_click_share,conversion_share1,conversion_share2,conversion_share3,total_conversion_share,new_asin_num,total_asin_num,new_asin_orders,new_asin_bsr_orders,is_first_text,is_ascending_text,is_search_text,top3_seller_orders,top3_seller_bsr_orders,top3_brand_orders,top3_brand_bsr_orders,page3_brand_num,page3_seller_num,brand_monopoly,seller_monopoly,created_time,updated_time,max_num_asin,is_self_max_num_asin,color_proportion,gross_profit_fee_air,gross_profit_fee_sea,multi_color_proportion,multi_size_proportion,st_4_20_ao_avg,st_4_20_ao_rate"
		else
			echo "请输入正确的date_type"
		fi
		hive_table=dwt_aba_st_analytics
		echo import_table:$import_table, hive_table:$hive_table
		#db_type=postgresql
		#db_type=mysql
		queue=default
		maps=10
		p_keys="site_name,date_type,date_info"
		p_values="$site_name,$date_type,$date_info"
		truncate_data
		export_data
	done
