#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`
d2=`expr $d2 + 0`


for site_name in ${site_name_array[*]}
	do
		echo 1. 当前连接的mysql数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导入数据
		import_table=${site_name}_st_month_${d1}_${d2}
		echo "improt_table:${import_table}"
		hive_table=ods_st_asin_month
		db_type=mysql
		hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}
		if [ $d2 -lt 9 ];
		then
			cols="week,asin,search_term,ao_val,orders,orders_sum,flow,order_flow,search_num,search_rank,quantity_being_sold,adv_compet,zr_page_rank,zr_page,zr_page_row,sp_page,sp_page_rank,sp_page_row,sb1_page,sb2_page,sb3_page,ac_page,bs_page,er_page,tr_page,search_term_type,created_at,updated_at"
		else		
			cols="0 as week,asin,search_term,st_ao_val as ao_val,asin_st_zr_orders as orders,asin_st_zr_orders_sum as orders_sum,asin_st_zr_flow as flow,asin_st_sp_flow as order_flow,st_search_num as search_num,st_rank as search_rank,st_quantity_being_sold as quantity_being_sold,st_adv_counts as adv_compet,st_asin_zr_page_rank as zr_page_rank,st_asin_zr_page as zr_page,st_asin_zr_page_row as zr_page_row,st_asin_sp_page as sp_page,st_asin_sp_page_rank as sp_page_rank,st_asin_sp_page_row as sp_page_row,st_asin_sb1_page as sb1_page,st_asin_sb2_page as sb2_page,st_asin_sb3_page as sb3_page,st_asin_ac_page as ac_page,st_asin_bs_page as bs_page,st_asin_er_page as er_page,st_asin_tr_page as tr_page,'null' as search_term_type,created_at,updated_at"
		fi
		query="select ${cols} from ${import_table} where 1=1 and \$CONDITIONS"
		import_data
	done



