/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.SynchronousQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.mapreduce.NullOutputCommitter;

public abstract class AsyncSqlOutputFormat<K extends SqoopRecord, V>
extends OutputFormat<K, V> {
    public static final String RECORDS_PER_STATEMENT_KEY = "sqoop.export.records.per.statement";
    public static final String STATEMENTS_PER_TRANSACTION_KEY = "sqoop.export.statements.per.transaction";
    public static final int DEFAULT_RECORDS_PER_STATEMENT = 100;
    public static final int DEFAULT_STATEMENTS_PER_TRANSACTION = 100;
    public static final int UNLIMITED_STATEMENTS_PER_TRANSACTION = -1;
    private static final Log LOG = LogFactory.getLog(AsyncSqlOutputFormat.class);

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public static class AsyncSqlExecThread
    extends Thread {
        private final Connection conn;
        private SQLException err;
        private SynchronousQueue<AsyncDBOperation> opsQueue;
        protected int curNumStatements;
        protected final int stmtsPerTx;

        public AsyncSqlExecThread(Connection conn, int stmtsPerTx) {
            this.conn = conn;
            this.err = null;
            this.opsQueue = new SynchronousQueue();
            this.stmtsPerTx = stmtsPerTx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AsyncDBOperation op = null;
                try {
                    op = this.opsQueue.take();
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Interrupted retrieving from operation queue: " + StringUtils.stringifyException((Throwable)ie)));
                    continue;
                }
                if (null == op) {
                    LOG.warn((Object)"Null operation in queue; illegal state.");
                    continue;
                }
                PreparedStatement stmt = op.getStatement();
                Connection connection = this.conn;
                synchronized (connection) {
                    block28: {
                        try {
                            if (null != stmt) {
                                if (op.execAsBatch()) {
                                    stmt.executeBatch();
                                } else {
                                    stmt.execute();
                                }
                                stmt.close();
                                stmt = null;
                                ++this.curNumStatements;
                            }
                            if (op.requiresCommit() || this.curNumStatements >= this.stmtsPerTx && this.stmtsPerTx != -1) {
                                LOG.debug((Object)("Committing transaction of " + this.curNumStatements + " statements"));
                                this.conn.commit();
                                this.curNumStatements = 0;
                            }
                        }
                        catch (BatchUpdateException batchE) {
                            if (batchE.getNextException() != null) {
                                this.setLastError(batchE.getNextException());
                            }
                            this.setLastError(batchE);
                        }
                        catch (SQLException sqlE) {
                            this.setLastError(sqlE);
                        }
                        finally {
                            if (null != stmt) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException sqlE) {
                                    this.setLastError(sqlE);
                                }
                            }
                            if (!op.stop()) break block28;
                            return;
                        }
                    }
                }
            }
        }

        public void put(AsyncDBOperation op) throws InterruptedException {
            this.opsQueue.put(op);
        }

        public synchronized SQLException getLastError() {
            SQLException e = this.err;
            this.err = null;
            return e;
        }

        private synchronized void setLastError(SQLException e) {
            if (this.err == null) {
                LOG.error((Object)("Got exception in update thread: " + StringUtils.stringifyException((Throwable)e)));
                this.err = e;
            } else {
                LOG.error((Object)("SQLException in update thread but error slot full: " + StringUtils.stringifyException((Throwable)e)));
            }
        }
    }

    public static class AsyncDBOperation {
        private final PreparedStatement stmt;
        private final boolean isBatch;
        private final boolean commit;
        private final boolean stopThread;

        @Deprecated
        public AsyncDBOperation(PreparedStatement s, boolean commitAndClose, boolean batch) {
            this(s, batch, commitAndClose, commitAndClose);
        }

        public AsyncDBOperation(PreparedStatement s, boolean batch, boolean commit, boolean stopThread) {
            this.stmt = s;
            this.isBatch = batch;
            this.commit = commit;
            this.stopThread = stopThread;
        }

        public PreparedStatement getStatement() {
            return this.stmt;
        }

        public boolean requiresCommit() {
            return this.commit;
        }

        public boolean stop() {
            return this.stopThread;
        }

        public boolean execAsBatch() {
            return this.isBatch;
        }
    }
}

