/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class MainframeDatasetInputSplit
extends InputSplit
implements Writable {
    private List<String> mainframeDatasets = new ArrayList<String>();
    private String currentDataset = null;
    private int currentIndex = -1;

    public void addDataset(String mainframeDataset) {
        this.mainframeDatasets.add(mainframeDataset);
    }

    public String getCurrentDataset() {
        return this.currentDataset;
    }

    public String getNextDataset() {
        if (this.hasMore()) {
            ++this.currentIndex;
            this.currentDataset = this.mainframeDatasets.get(this.currentIndex);
        } else {
            this.currentDataset = null;
        }
        return this.currentDataset;
    }

    public boolean hasMore() {
        return this.currentIndex < this.mainframeDatasets.size() - 1;
    }

    public long getLength() throws IOException, InterruptedException {
        return this.mainframeDatasets.size();
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.mainframeDatasets.size());
        for (String ds : this.mainframeDatasets) {
            dataOutput.writeUTF(ds);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int numberOfDatasets = dataInput.readInt();
        for (int i = 0; i < numberOfDatasets; ++i) {
            this.mainframeDatasets.add(dataInput.readUTF());
        }
    }
}

