/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import com.cloudera.sqoop.lib.FieldMapProcessor;
import com.cloudera.sqoop.lib.FieldMappable;
import com.cloudera.sqoop.lib.ProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.accumulo.MutationTransformer;
import org.apache.sqoop.accumulo.ToStringMutationTransformer;

public class AccumuloMutationProcessor
implements Closeable,
Configurable,
FieldMapProcessor {
    private Configuration conf;
    private MutationTransformer mutationTransformer;
    private String tableName;
    private BatchWriter table;

    public void setConf(Configuration config) {
        this.conf = config;
        Class xformerClass = this.conf.getClass("sqoop.accumulo.insert.put.transformer.class", ToStringMutationTransformer.class);
        this.mutationTransformer = (MutationTransformer)ReflectionUtils.newInstance((Class)xformerClass, (Configuration)this.conf);
        if (null == this.mutationTransformer) {
            throw new RuntimeException("Could not instantiate MutationTransformer.");
        }
        String colFam = this.conf.get("sqoop.accumulo.insert.column.family", null);
        if (null == colFam) {
            throw new RuntimeException("Accumulo column family not set.");
        }
        this.mutationTransformer.setColumnFamily(colFam);
        String rowKey = this.conf.get("sqoop.accumulo.insert.row.key.column", null);
        if (null == rowKey) {
            throw new RuntimeException("Row key column not set.");
        }
        this.mutationTransformer.setRowKeyColumn(rowKey);
        String vis = this.conf.get("sqoop.accumulo.insert.visibility", null);
        this.mutationTransformer.setVisibility(vis);
        this.tableName = this.conf.get("sqoop.accumulo.insert.table", null);
        String zookeeper = this.conf.get("sqoop.accumulo.zookeeper.hostnames");
        String instance = this.conf.get("sqoop.accumulo.instance.name");
        ZooKeeperInstance inst = new ZooKeeperInstance(instance, zookeeper);
        String username = this.conf.get("sqoop.accumulo.user.name");
        String pw = this.conf.get("sqoop.accumulo.password");
        if (null == pw) {
            pw = "";
        }
        byte[] password = pw.getBytes();
        BatchWriterConfig bwc = new BatchWriterConfig();
        long bs = this.conf.getLong("sqoop.accumulo.batch.size", 10240000L);
        bwc.setMaxMemory(bs);
        long la = this.conf.getLong("sqoop.accumulo.max.latency", 5000L);
        bwc.setMaxLatency(la, TimeUnit.MILLISECONDS);
        try {
            Connector conn = inst.getConnector(username, (AuthenticationToken)new PasswordToken(password));
            this.table = conn.createBatchWriter(this.tableName, bwc);
        }
        catch (AccumuloException ex) {
            throw new RuntimeException("Error accessing Accumulo", ex);
        }
        catch (AccumuloSecurityException aex) {
            throw new RuntimeException("Security exception accessing Accumulo", aex);
        }
        catch (TableNotFoundException tex) {
            throw new RuntimeException("Accumulo table " + this.tableName + " not found", tex);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void accept(FieldMappable record) throws IOException, ProcessingException {
        Map<String, Object> fields = record.getFieldMap();
        Iterable<Mutation> putList = this.mutationTransformer.getMutations(fields);
        if (null != putList) {
            for (Mutation m : putList) {
                try {
                    this.table.addMutation(m);
                }
                catch (MutationsRejectedException ex) {
                    throw new IOException("Mutation rejected", ex);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.table.close();
        }
        catch (MutationsRejectedException ex) {
            throw new IOException("Mutations rejected", ex);
        }
    }
}

