"""
   @Author      : HuangJian
   @Description : 店铺月报表--传参为month类型
   @SourceTable : us_seller_account_feedback_report
   @SinkTable   : ods_seller_account_feedback_report
   @CreateTime  : 2022/05/19 14:55
   @UpdateTime  : 2022/05/19 14:55
"""


import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.db_util import DBUtil
from utils.common_util import CommonUtil
from utils.common_util import DateTypes
from utils.hdfs_utils import HdfsUtils
from utils.spark_util import SparkUtil


if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"
    # 该表为月报表，因此加一层date_type验证
    assert date_type == DateTypes.month.name, "date_type类型不对，应为month"


    hive_table = f"ods_seller_account_feedback_report"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }

    # 落表路径校验
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")

    # 日期拆分
    d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)
    import_table = f"{site_name}_seller_account_feedback_report"
    db_type = 'mysql'


    sql_query = f"""
                    select 
                     id,
                     ym as `year_month`,
                     account_id,
                     account_name,
                     site_name as country_name,
                     count_30_day,
                     count_30_day_rate,
                     count_1_year,
                     count_lifetime,
                     count_lifetime_rate,
                     num,
                     num_new,
                     created_at,
                     updated_at,
                     seller_id
                    from {import_table} 
                    where 1=1
                    and ym = '{d1}_{d2}' 
                    and \$CONDITIONS
                    """

    # 进行schema和数据校验
    CommonUtil.check_schema_before_import(db_type=db_type,
                                          site_name=site_name,
                                          query=sql_query,
                                          hive_tb_name=hive_table,
                                          msg_usr=['chenyuanjie'])

    # 生成导出脚本
    import_sh = CommonUtil.build_import_sh(site_name=site_name,
                                           db_type=db_type,
                                           query=sql_query,
                                           hdfs_path=hdfs_path)
    # 导入前先删除原始hdfs数据
    HdfsUtils.delete_hdfs_file(hdfs_path)
    # 创建ssh Client对象--用于执行cmd命令
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, import_sh, ignore_err=False)
    # 创建lzo索引和修复元数据
    CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_table)
    # 关闭链接
    client.close()
