#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3

for site_name in ${site_name_array[*]}
	do
		echo 1. 当前连接的mysql数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导入数据
		import_table=${site_name}_self_asin
		hive_table=ods_self_asin
		db_type=mysql
		hdfs_path=/home/big_data_selection/ods/${hive_table}/site_name=${site_name}/date_type=$date_type/date_info=$date_info
		cols="id,asin,created_at as created_time,updated_at as updated_time"
		query="select ${cols} from ${import_table} where 1=1 and \$CONDITIONS"
		import_data
	done

