/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.sqoop.accumulo.MutationTransformer;

public class ToStringMutationTransformer
extends MutationTransformer {
    public static final Log LOG = LogFactory.getLog((String)ToStringMutationTransformer.class.getName());

    @Override
    public Iterable<Mutation> getMutations(Map<String, Object> fields) throws IOException {
        String rowKeyCol = this.getRowKeyColumn();
        String colFamily = this.getColumnFamily();
        Object rowKey = fields.get(rowKeyCol);
        String vis = this.getVisibility();
        if (null == rowKey) {
            LOG.warn((Object)("Could not insert row with null value for row-key column: " + rowKeyCol));
            return null;
        }
        ColumnVisibility colVis = null;
        if (null != vis && vis.length() > 0) {
            colVis = new ColumnVisibility(vis);
        }
        Mutation mut = new Mutation((CharSequence)rowKey.toString());
        for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
            Object val;
            String colName = fieldEntry.getKey();
            if (colName.equals(rowKeyCol) || null == (val = fieldEntry.getValue())) continue;
            if (null == colVis) {
                mut.put(new Text(colFamily), new Text(colName), new Value(val.toString().getBytes("UTF8")));
                continue;
            }
            mut.put(new Text(colFamily), new Text(colName), colVis, new Value(val.toString().getBytes("UTF8")));
        }
        return Collections.singletonList(mut);
    }
}

