/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db.netezza;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.sqoop.config.ConfigurationHelper;
import org.apache.sqoop.lib.RecordParser;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.db.netezza.NetezzaExternalTableImportMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatImportHelper;

public class NetezzaExternalTableHCatImportMapper
extends NetezzaExternalTableImportMapper<NullWritable, HCatRecord> {
    private SqoopHCatImportHelper helper;
    private SqoopRecord sqoopRecord;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.helper = new SqoopHCatImportHelper(conf);
        String recordClassName = conf.get(ConfigurationHelper.getDbInputClassProperty());
        if (null == recordClassName) {
            throw new IOException("DB Input class name is not set!");
        }
        try {
            Class<?> cls = Class.forName(recordClassName, true, Thread.currentThread().getContextClassLoader());
            this.sqoopRecord = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        if (null == this.sqoopRecord) {
            throw new IOException("Could not instantiate object of type " + recordClassName);
        }
    }

    @Override
    protected void writeRecord(Text text, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.sqoopRecord.parse(text);
            context.write((Object)NullWritable.get(), (Object)this.helper.convertToHCatRecord(this.sqoopRecord));
        }
        catch (RecordParser.ParseError pe) {
            throw new IOException("Exception parsing netezza import record", pe);
        }
    }
}

