import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.common_util import CommonUtil
from utils.secure_db_client import get_remote_engine

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None).replace("month_week", "month")
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"

    db_type = 'postgresql_14'
    d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)
    d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
    import_table = f"{site_name}_brand_analytics_month_{d1}_{d2}"
    sql_query = f"""
        select 
            id,
            search_term,
            quantity_being_sold,
            date_info as date_flag,
            created_time,
            updated_time,
            quantity_being_sold_str,
            result_count,
            departments
        from {import_table} 
        where 1=1 
        and \$CONDITIONS
    """

    hive_table = "ods_st_quantity_being_sold"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_table, partition_dict=partition_dict)

    if site_name == 'us':
        map_num = 4
    else:
        map_num = 1

    engine = get_remote_engine(
        site_name=site_name,
        db_type=db_type
    )

    engine.sqoop_raw_import(
        query=sql_query,
        hive_table=hive_table,
        hdfs_path=hdfs_path,
        partitions=partition_dict,
        m=map_num,
        split_by='id'
    )

    pass
