/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopManagerFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatInsert;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatUpdate;
import org.apache.sqoop.manager.oracle.OracleTable;

public final class OraOopUtilities {
    private static String currentSessionUser = null;
    protected static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopUtilities.class.getName());
    public static final String SQOOP_JOB_TYPE = "oraoop.sqoop.job.type";

    private OraOopUtilities() {
    }

    public static List<String> copyStringList(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        result.addAll(list);
        return result;
    }

    public static OracleTable decodeOracleTableName(String oracleConnectionUserName, String tableStr) {
        String tableName;
        String tableOwner;
        String[] tableStrings = tableStr.split("\"");
        if (oracleConnectionUserName == null) {
            oracleConnectionUserName = currentSessionUser;
        }
        block0 : switch (tableStrings.length) {
            case 1: {
                tableStrings = tableStr.split("\\.");
                switch (tableStrings.length) {
                    case 1: {
                        tableOwner = oracleConnectionUserName.toUpperCase();
                        tableName = tableStrings[0].toUpperCase();
                        break block0;
                    }
                    case 2: {
                        tableOwner = tableStrings[0].toUpperCase();
                        tableName = tableStrings[1].toUpperCase();
                        break block0;
                    }
                }
                LOG.debug(String.format("Unable to decode the table name (displayed in double quotes): \"%s\"", tableStr));
                throw new RuntimeException(String.format("Unable to decode the table name: %s", tableStr));
            }
            case 2: {
                if (tableStrings[0] == null || tableStrings[0].isEmpty()) {
                    tableOwner = oracleConnectionUserName.toUpperCase();
                } else {
                    tableOwner = tableStrings[0].toUpperCase();
                    if (tableOwner.endsWith(".")) {
                        tableOwner = tableOwner.substring(0, tableOwner.length() - 1);
                    }
                }
                tableName = tableStrings[1];
                break;
            }
            case 3: {
                tableOwner = tableStrings[1];
                tableName = tableStrings[2].toUpperCase();
                if (!tableName.startsWith(".")) break;
                tableName = tableName.substring(1, tableName.length());
                break;
            }
            case 4: {
                tableOwner = tableStrings[1];
                tableName = tableStrings[3];
                break;
            }
            default: {
                LOG.debug(String.format("Unable to decode the table name (displayed in double quotes): \"%s\"", tableStr));
                throw new RuntimeException(String.format("Unable to decode the table name: %s", tableStr));
            }
        }
        OracleTable result = new OracleTable(tableOwner, tableName);
        return result;
    }

    public static OracleTable decodeOracleTableName(String oracleConnectionUserName, String tableStr, Configuration conf) {
        OracleTable result = new OracleTable();
        if (conf != null) {
            String tableOwner = conf.get("oraoop.table.owner");
            String tableName = conf.get("oraoop.table.name");
            result = new OracleTable(tableOwner, tableName);
        }
        if (result.getSchema() == null || result.getName() == null) {
            result = OraOopUtilities.decodeOracleTableName(oracleConnectionUserName, tableStr);
            LOG.debug(String.format("The Oracle table context has been derived from:\n\toracleConnectionUserName = %s\n\ttableStr = %s\n\tas:\n\towner : %s\n\ttable : %s", oracleConnectionUserName, tableStr, result.getSchema(), result.getName()));
            if (conf != null) {
                conf.set("oraoop.table.owner", result.getSchema());
                conf.set("oraoop.table.name", result.getName());
            }
        }
        return result;
    }

    public static boolean oracleJdbcUrlGenerationDisabled(Configuration conf) {
        return conf.getBoolean("oraoop.jdbc.url.verbatim", false);
    }

    public static boolean userWantsOracleSessionStatisticsReports(Configuration conf) {
        return conf.getBoolean("oraoop.report.session.statistics", false);
    }

    public static boolean enableDebugLoggingIfRequired(Configuration conf) {
        boolean result = false;
        try {
            Level desiredOraOopLoggingLevel = Level.toLevel((String)conf.get("oraoop.logging.level"), (Level)Level.INFO);
            Level sqoopLogLevel = Logger.getLogger((String)Sqoop.class.getName()).getParent().getLevel();
            if (desiredOraOopLoggingLevel == Level.DEBUG || desiredOraOopLoggingLevel == Level.ALL || sqoopLogLevel == Level.DEBUG || sqoopLogLevel == Level.ALL) {
                Category oraOopLogger = Logger.getLogger((String)OraOopManagerFactory.class.getName()).getParent();
                oraOopLogger.setLevel(Level.DEBUG);
                LOG.debug("Enabled OraOop debug logging.");
                result = true;
                conf.set("oraoop.logging.level", Level.DEBUG.toString());
            }
        }
        catch (Exception ex) {
            LOG.error(String.format("Unable to determine whether debug logging should be enabled.\n%s", OraOopUtilities.getFullExceptionMessage(ex)));
        }
        return result;
    }

    public static String generateDataChunkId(int fileId, int fileBatch) {
        StringBuilder sb = new StringBuilder();
        return sb.append(fileId).append("_").append(fileBatch).toString();
    }

    public static String getCurrentMethodName() {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        return String.format("%s()", stackTraceElements[1].getMethodName());
    }

    public static String[] getDuplicatedStringArrayValues(String[] list, boolean ignoreCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list argument cannot be null");
        }
        ArrayList<String> duplicates = new ArrayList<String>();
        for (int idx1 = 0; idx1 < list.length - 1; ++idx1) {
            for (int idx2 = idx1 + 1; idx2 < list.length; ++idx2) {
                if (list[idx1].equals(list[idx2])) {
                    if (duplicates.contains(list[idx2])) continue;
                    duplicates.add(list[idx2]);
                    continue;
                }
                if (!ignoreCase || !list[idx1].equalsIgnoreCase(list[idx2]) || OraOopUtilities.stringListIndexOf(duplicates, list[idx2], ignoreCase) != -1) continue;
                duplicates.add(list[idx2]);
            }
        }
        return duplicates.toArray(new String[duplicates.size()]);
    }

    public static String getFullExceptionMessage(Exception ex) {
        ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayStream);
        ex.printStackTrace(printStream);
        return arrayStream.toString();
    }

    public static int getMinNumberOfImportMappersAcceptedByOraOop(Configuration conf) {
        return conf.getInt("oraoop.min.import.mappers", 2);
    }

    public static int getMinAppendValuesBatchSize(Configuration conf) {
        return conf.getInt("oraoop.min.append.values.batch.size", 5000);
    }

    public static int getMinNumberOfExportMappersAcceptedByOraOop(Configuration conf) {
        return conf.getInt("oraoop.min.export.mappers", 2);
    }

    public static int getMinNumberOfOracleRacActiveInstancesForDynamicJdbcUrlUse(Configuration conf) {
        return conf.getInt("oraoop.min.rac.active.instances", 2);
    }

    public static int getNumberOfDataChunksPerOracleDataFile(int desiredNumberOfMappers, Configuration conf) {
        String MAPPER_MULTIPLIER = "oraoop.datachunk.mapper.multiplier";
        String RESULT_INCREMENT = "oraoop.datachunk.result.increment";
        int numberToMultiplyMappersBy = conf.getInt("oraoop.datachunk.mapper.multiplier", 2);
        int numberToIncrementResultBy = conf.getInt("oraoop.datachunk.result.increment", 1);
        int numberOfDataChunksPerOracleDataFile = desiredNumberOfMappers * numberToMultiplyMappersBy + numberToIncrementResultBy;
        LOG.debug(String.format("%s:\n\t%s=%d\n\t%s=%d\n\tdesiredNumberOfMappers=%d\n\tresult=%d", OraOopUtilities.getCurrentMethodName(), "oraoop.datachunk.mapper.multiplier", numberToMultiplyMappersBy, "oraoop.datachunk.result.increment", numberToIncrementResultBy, desiredNumberOfMappers, numberOfDataChunksPerOracleDataFile));
        return numberOfDataChunksPerOracleDataFile;
    }

    public static OraOopConstants.OraOopOracleDataChunkMethod getOraOopOracleDataChunkMethod(Configuration conf) {
        OraOopConstants.OraOopOracleDataChunkMethod result;
        if (conf == null) {
            throw new IllegalArgumentException("The conf argument cannot be null");
        }
        String strMethod = conf.get("oraoop.chunk.method");
        if (strMethod == null) {
            return OraOopConstants.ORAOOP_ORACLE_DATA_CHUNK_METHOD_DEFAULT;
        }
        try {
            strMethod = strMethod.toUpperCase().trim();
            result = OraOopConstants.OraOopOracleDataChunkMethod.valueOf(strMethod);
        }
        catch (IllegalArgumentException ex) {
            result = OraOopConstants.ORAOOP_ORACLE_DATA_CHUNK_METHOD_DEFAULT;
            LOG.error("An invalid value of \"" + strMethod + "\" was specified for the \"" + "oraoop.chunk.method" + "\" configuration property value.\n" + "\tThe default value of " + (Object)((Object)OraOopConstants.ORAOOP_ORACLE_DATA_CHUNK_METHOD_DEFAULT) + " will be used.");
        }
        return result;
    }

    public static OraOopConstants.OraOopOracleBlockToSplitAllocationMethod getOraOopOracleBlockToSplitAllocationMethod(Configuration conf, OraOopConstants.OraOopOracleBlockToSplitAllocationMethod defaultMethod) {
        OraOopConstants.OraOopOracleBlockToSplitAllocationMethod result;
        if (conf == null) {
            throw new IllegalArgumentException("The conf argument cannot be null");
        }
        String strMethod = conf.get("oraoop.block.allocation");
        if (strMethod == null) {
            return defaultMethod;
        }
        try {
            strMethod = strMethod.toUpperCase().trim();
            result = OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.valueOf(strMethod);
        }
        catch (IllegalArgumentException ex) {
            result = defaultMethod;
            String errorMsg = String.format("An invalid value of \"%s\" was specified for the \"%s\" configuration property value.\n\tValid values are: %s\n\tThe default value of %s will be used.", strMethod, "oraoop.block.allocation", OraOopUtilities.getOraOopOracleBlockToSplitAllocationMethods(), defaultMethod.name());
            LOG.error(errorMsg);
        }
        return result;
    }

    private static String getOraOopOracleBlockToSplitAllocationMethods() {
        OraOopConstants.OraOopOracleBlockToSplitAllocationMethod[] values = OraOopConstants.OraOopOracleBlockToSplitAllocationMethod.values();
        StringBuilder result = new StringBuilder(2 * values.length - 1);
        for (int idx = 0; idx < values.length; ++idx) {
            OraOopConstants.OraOopOracleBlockToSplitAllocationMethod value = values[idx];
            if (idx > 0) {
                result.append(" or ");
            }
            result.append(value.name());
        }
        return result.toString();
    }

    public static OraOopConstants.OraOopTableImportWhereClauseLocation getOraOopTableImportWhereClauseLocation(Configuration conf, OraOopConstants.OraOopTableImportWhereClauseLocation defaultLocation) {
        OraOopConstants.OraOopTableImportWhereClauseLocation result;
        if (conf == null) {
            throw new IllegalArgumentException("The conf argument cannot be null");
        }
        String strLocation = conf.get("oraoop.table.import.where.clause.location");
        if (strLocation == null) {
            return defaultLocation;
        }
        try {
            strLocation = strLocation.toUpperCase().trim();
            result = OraOopConstants.OraOopTableImportWhereClauseLocation.valueOf(strLocation);
        }
        catch (IllegalArgumentException ex) {
            result = defaultLocation;
            String errorMsg = String.format("An invalid value of \"%s\"was specified for the \"%s\" configuration property value.\n\tValid values are: %s\n\tThe default value of %s will be used.", strLocation, "oraoop.table.import.where.clause.location", OraOopUtilities.getOraOopTableImportWhereClauseLocations(), defaultLocation.name());
            LOG.error(errorMsg);
        }
        return result;
    }

    private static String getOraOopTableImportWhereClauseLocations() {
        OraOopConstants.OraOopTableImportWhereClauseLocation[] locationValues = OraOopConstants.OraOopTableImportWhereClauseLocation.values();
        StringBuilder result = new StringBuilder(2 * locationValues.length - 1);
        for (int idx = 0; idx < locationValues.length; ++idx) {
            OraOopConstants.OraOopTableImportWhereClauseLocation locationValue = locationValues[idx];
            if (idx > 0) {
                result.append(" or ");
            }
            result.append(locationValue.name());
        }
        return result.toString();
    }

    public static String getOutputDirectory(Configuration conf) {
        String workingDir = conf.get("mapred.working.dir");
        String outputDir = conf.get("mapred.output.dir");
        return workingDir + "/" + outputDir;
    }

    public static String padLeft(String s, int n) {
        return StringUtils.leftPad((String)s, (int)n);
    }

    public static String padRight(String s, int n) {
        return StringUtils.rightPad((String)s, (int)n);
    }

    public static String replaceConfigurationExpression(String str, Configuration conf) {
        String configValue;
        int startPos = str.indexOf(123);
        int endPos = str.indexOf(125);
        if (startPos == -1 || endPos == -1) {
            return str;
        }
        String configName = null;
        String defaultValue = null;
        String expression = str.substring(startPos + 1, endPos);
        int defaultValuePos = expression.indexOf(124);
        if (defaultValuePos == -1) {
            configName = expression;
        } else {
            configName = expression.substring(0, defaultValuePos);
            defaultValue = expression.substring(defaultValuePos + 1);
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        if ((configValue = conf.get(configName)) == null) {
            configValue = defaultValue;
        }
        String result = str.replace(String.format("{%s}", expression), configValue);
        LOG.debug(String.format("The expression:\n%s\nwas replaced with:\n%s", str, result));
        result = OraOopUtilities.replaceConfigurationExpression(result, conf);
        return result;
    }

    public static boolean stackContainsClass(String className) {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = new Throwable().getStackTrace()) {
            if (!stackTraceElement.getClassName().equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }

    public static Object startSessionSnapshot(Connection connection) {
        Object result = null;
        try {
            Class<?> oraOopOraStatsClass = Class.forName("quest.com.oraOop.oracleStats.OraOopOraStats");
            Method startSnapshotMethod = oraOopOraStatsClass.getMethod("startSnapshot", Connection.class);
            if (connection != null) {
                result = startSnapshotMethod.invoke(null, connection);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static OraOopStatsReports stopSessionSnapshot(Object oraOopOraStats) {
        OraOopStatsReports result = new OraOopStatsReports();
        if (oraOopOraStats == null) {
            return result;
        }
        try {
            Class<?> oraOopOraStatsClass = Class.forName("quest.com.oraOop.oracleStats.OraOopOraStats");
            Method finalizeSnapshotMethod = oraOopOraStatsClass.getMethod("finalizeSnapshot", null);
            finalizeSnapshotMethod.invoke(oraOopOraStats, (Object[])null);
            Method performanceReportCsvMethod = oraOopOraStatsClass.getMethod("getStatisticsCSV", null);
            result.setCsvReport((String)performanceReportCsvMethod.invoke(oraOopOraStats, (Object[])null));
            Method performanceReportMethod = oraOopOraStatsClass.getMethod("performanceReport", null);
            result.setPerformanceReport((String)performanceReportMethod.invoke(oraOopOraStats, (Object[])null));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static boolean stringArrayContains(String[] list, String value, boolean ignoreCase) {
        return OraOopUtilities.stringArrayIndexOf(list, value, ignoreCase) > -1;
    }

    public static int stringArrayIndexOf(String[] list, String value, boolean ignoreCase) {
        for (int idx = 0; idx < list.length; ++idx) {
            if (list[idx].equals(value)) {
                return idx;
            }
            if (!ignoreCase || !list[idx].equalsIgnoreCase(value)) continue;
            return idx;
        }
        return -1;
    }

    public static String stringArrayToCSV(String[] list) {
        return OraOopUtilities.stringArrayToCSV(list, "");
    }

    public static String stringArrayToCSV(String[] list, String encloseValuesWith) {
        StringBuilder result = new StringBuilder(list.length * 2 - 1);
        for (int idx = 0; idx < list.length; ++idx) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(String.format("%1$s%2$s%1$s", encloseValuesWith, list[idx]));
        }
        return result.toString();
    }

    public static int stringListIndexOf(List<String> list, String value, boolean ignoreCase) {
        for (int idx = 0; idx < list.size(); ++idx) {
            if (list.get(idx).equals(value)) {
                return idx;
            }
            if (!ignoreCase || !list.get(idx).equalsIgnoreCase(value)) continue;
            return idx;
        }
        return -1;
    }

    public static void writeOutputFile(Configuration conf, String fileName, String fileText) {
        Path uniqueFileName = null;
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)conf);
            int suffix = 0;
            String fileNameTemplate = fileName + "%s";
            while (fileSystem.exists(uniqueFileName = new Path(OraOopUtilities.getOutputDirectory(conf), String.format(fileNameTemplate, suffix == 0 ? "" : String.format(" (%d)", suffix))))) {
                ++suffix;
            }
            FSDataOutputStream outputStream = fileSystem.create(uniqueFileName, false);
            if (fileText != null) {
                outputStream.writeBytes(fileText);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException ex) {
            LOG.error(String.format("Error attempting to write the file %s\n%s", uniqueFileName == null ? "null" : uniqueFileName.toUri(), OraOopUtilities.getFullExceptionMessage(ex)));
        }
    }

    public static String getOracleServiceName(Configuration conf) {
        return conf.get("oraoop.oracle.rac.service.name", "");
    }

    public static String generateOracleSidJdbcUrl(String hostName, int port, String sid) {
        return String.format("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%d)))(CONNECT_DATA=(SERVER=DEDICATED)(SID=%s)))", hostName, port, sid);
    }

    public static String generateOracleServiceNameJdbcUrl(String hostName, int port, String serviceName) {
        return String.format("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%d)))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=%s)))", hostName, port, serviceName);
    }

    public static String generateOracleTnsNameJdbcUrl(String tnsName) {
        return String.format("jdbc:oracle:thin:@%s", tnsName);
    }

    public static String getMapperJdbcUrlPropertyName(int mapperId, Configuration conf) {
        return String.format("oraoop.mapper.jdbc.url.%d", mapperId);
    }

    public static void rememberSqoopJobType(OraOopConstants.Sqoop.Tool jobType, Configuration conf) {
        conf.set(SQOOP_JOB_TYPE, jobType.name());
    }

    public static OraOopConstants.Sqoop.Tool recallSqoopJobType(Configuration conf) {
        String jobType = conf.get(SQOOP_JOB_TYPE);
        if (jobType == null || jobType.isEmpty()) {
            throw new RuntimeException("RecallSqoopJobType() cannot be called unless RememberSqoopJobType() has been used.");
        }
        OraOopConstants.Sqoop.Tool result = OraOopConstants.Sqoop.Tool.valueOf(jobType);
        return result;
    }

    public static boolean omitLobAndLongColumnsDuringImport(Configuration conf) {
        return conf.getBoolean("oraoop.import.omit.lobs.and.long", false);
    }

    public static boolean oracleSessionHasBeenKilled(Exception exception) {
        for (Throwable ex = exception; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof SQLException) || ((SQLException)ex).getErrorCode() != 28) continue;
            return true;
        }
        return false;
    }

    private static String formatTimestampForOracleObjectName(Object oracleDateTime) {
        String jobTimeStr = OraOopOracleQueries.oraDATEToString(oracleDateTime, "yyyymmdd_hh24miss");
        return jobTimeStr;
    }

    private static Object decodeTimestampFromOracleObjectName(String oracleObjectNameTimestampFragment) {
        String dateString = oracleObjectNameTimestampFragment;
        String dateFormatString = "yyyymmdd_hh24miss";
        try {
            String year = oracleObjectNameTimestampFragment.substring(0, 4);
            String month = oracleObjectNameTimestampFragment.substring(4, 6);
            String day = oracleObjectNameTimestampFragment.substring(6, 8);
            String hour = oracleObjectNameTimestampFragment.substring(9, 11);
            String minute = oracleObjectNameTimestampFragment.substring(11, 13);
            String second = oracleObjectNameTimestampFragment.substring(13, 15);
            dateString = String.format("%s/%s/%s %s:%s:%s", year, month, day, hour, minute, second);
            dateFormatString = "yyyy/mm/dd hh24:mi:ss";
            return OraOopOracleQueries.oraDATEFromString(dateString, dateFormatString);
        }
        catch (Exception ex) {
            LOG.debug(String.format("%s could not convert the string \"%s\" into a DATE via the format string \"%s\".\nThe error encountered was:\n%s", OraOopUtilities.getCurrentMethodName(), dateString, dateFormatString, OraOopUtilities.getFullExceptionMessage(ex)));
            return null;
        }
    }

    public static String createExportTablePartitionNameFromOracleTimestamp(Object oracleDateTime) {
        return "ORAOOP_" + OraOopUtilities.formatTimestampForOracleObjectName(oracleDateTime);
    }

    public static String createExportTableNamePrefixFromOracleTimestamp(Object oracleDateTime) {
        return "ORAOOP_" + OraOopUtilities.formatTimestampForOracleObjectName(oracleDateTime);
    }

    public static Object decodeExportTableNamePrefix(String tableNamePrefix) {
        if (tableNamePrefix == null || tableNamePrefix.isEmpty()) {
            return null;
        }
        if (!tableNamePrefix.startsWith("ORAOOP_")) {
            return null;
        }
        String formattedTimestamp = tableNamePrefix.substring("ORAOOP_".length(), tableNamePrefix.length());
        return OraOopUtilities.decodeTimestampFromOracleObjectName(formattedTimestamp);
    }

    private static boolean userWantsToCreateExportTableFromTemplate(Configuration conf) {
        String exportTableTemplate = conf.get("oraoop.template.table", "");
        if (exportTableTemplate.isEmpty()) {
            return false;
        }
        OraOopConstants.Sqoop.Tool tool = OraOopUtilities.recallSqoopJobType(conf);
        switch (tool) {
            case UNKNOWN: 
            case EXPORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean enableOracleParallelProcessingDuringExport(Configuration conf) {
        return conf.getBoolean("oraoop.export.oracle.parallelization.enabled", false);
    }

    public static boolean userWantsToCreatePartitionedExportTableFromTemplate(Configuration conf) {
        return OraOopUtilities.userWantsToCreateExportTableFromTemplate(conf) && conf.getBoolean("oraoop.partitioned", false);
    }

    public static boolean userWantsToCreateNonPartitionedExportTableFromTemplate(Configuration conf) {
        return OraOopUtilities.userWantsToCreateExportTableFromTemplate(conf) && !conf.getBoolean("oraoop.partitioned", false);
    }

    public static String generateExportTableSubPartitionName(int mapperId, Object sysDateTime, Configuration conf) {
        String partitionName = OraOopUtilities.createExportTablePartitionNameFromOracleTimestamp(sysDateTime);
        String subPartitionName = String.format("%s_MAP_%d", partitionName, mapperId);
        if (subPartitionName.length() > 30) {
            throw new RuntimeException(String.format("The generated Oracle subpartition name \"%s\" is longer than %d characters.", subPartitionName, 30));
        }
        return subPartitionName;
    }

    public static String[] generateExportTableSubPartitionNames(int numMappers, Object sysDateTime, Configuration conf) {
        String[] result = new String[numMappers];
        for (int idx = 0; idx < numMappers; ++idx) {
            result[idx] = OraOopUtilities.generateExportTableSubPartitionName(idx, sysDateTime, conf);
        }
        return result;
    }

    public static OracleTable generateExportTableMapperTableName(int mapperId, Object sysDateTime, String schema) {
        return OraOopUtilities.generateExportTableMapperTableName(Integer.toString(mapperId), sysDateTime, schema);
    }

    public static OracleTable generateExportTableMapperTableName(String mapperSuffix, Object sysDateTime, String schema) {
        String mapperTableNamePrefix = OraOopUtilities.createExportTableNamePrefixFromOracleTimestamp(sysDateTime);
        String tableName = String.format("%s_%s", mapperTableNamePrefix, mapperSuffix);
        if (tableName.length() > 30) {
            throw new RuntimeException(String.format("The generated Oracle table name \"%s\" is longer than %d characters.", tableName, 30));
        }
        return new OracleTable(schema, tableName);
    }

    public static DecodedExportMapperTableName decodeExportTableMapperTableName(OracleTable oracleTable) {
        DecodedExportMapperTableName result = null;
        try {
            int lastUnderScoreIndex = oracleTable.getName().lastIndexOf("_");
            if (lastUnderScoreIndex == -1) {
                return result;
            }
            String dateFragment = oracleTable.getName().substring(0, lastUnderScoreIndex);
            String mapperIdFragment = oracleTable.getName().substring(lastUnderScoreIndex + 1, oracleTable.getName().length());
            Object sysDateTime = OraOopUtilities.decodeExportTableNamePrefix(dateFragment);
            if (sysDateTime != null) {
                result = new DecodedExportMapperTableName();
                result.setTableDateTime(sysDateTime);
                result.setMapperId(mapperIdFragment);
            }
        }
        catch (Exception ex) {
            LOG.debug(String.format("Error when attempting to decode the export mapper-table name \"%s\".", oracleTable.toString()), ex);
        }
        return result;
    }

    public static void rememberOracleDateTime(Configuration conf, String propertyName, String dateTime) {
        conf.set(propertyName, dateTime);
    }

    public static Object recallOracleDateTime(Configuration conf, String propertyName) {
        String dateTimeStr = conf.get(propertyName);
        if (dateTimeStr == null || dateTimeStr.isEmpty()) {
            throw new RuntimeException(String.format("Unable to recall the value of the property \"%s\".", propertyName));
        }
        return OraOopOracleQueries.oraDATEFromString(dateTimeStr, "yyyy-mm-dd hh24:mi:ss");
    }

    public static OraOopOutputFormatUpdate.UpdateMode getExportUpdateMode(Configuration conf) {
        OraOopOutputFormatUpdate.UpdateMode updateMode = OraOopOutputFormatUpdate.UpdateMode.Update;
        boolean mergeData = conf.getBoolean("oraoop.export.merge", false);
        if (mergeData) {
            updateMode = OraOopOutputFormatUpdate.UpdateMode.Merge;
        }
        return updateMode;
    }

    public static OraOopOutputFormatInsert.InsertMode getExportInsertMode(Configuration conf) {
        OraOopOutputFormatInsert.InsertMode result = OraOopOutputFormatInsert.InsertMode.DirectInsert;
        if (OraOopUtilities.userWantsToCreatePartitionedExportTableFromTemplate(conf) || conf.getBoolean("oraoop.export.table.has.oraoop.partitions", false)) {
            result = OraOopOutputFormatInsert.InsertMode.ExchangePartition;
        }
        return result;
    }

    public static String getJavaClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String replaceAll(String inputString, String textToReplace, String replaceWith) {
        String result = inputString.replaceAll(textToReplace, replaceWith);
        if (!result.equals(inputString)) {
            result = OraOopUtilities.replaceAll(result, textToReplace, replaceWith);
        }
        return result;
    }

    public static String getTemporaryTableStorageClause(Configuration conf) {
        String result = conf.get("oraoop.temporary.table.storage.clause", "");
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getExportTableStorageClause(Configuration conf) {
        String result = conf.get("oraoop.table.storage.clause", "");
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String[] getExportUpdateKeyColumnNames(SqoopOptions options) {
        String updateKey = options.getUpdateKeyCol();
        return OraOopUtilities.getExtraExportUpdateKeyColumnNames(updateKey, options.getConf());
    }

    public static String[] getExportUpdateKeyColumnNames(Configuration conf) {
        String updateKey = conf.get("sqoop.mapreduce.export.update.col");
        return OraOopUtilities.getExtraExportUpdateKeyColumnNames(updateKey, conf);
    }

    public static List<String> splitStringList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null && !value.isEmpty()) {
            Pattern pattern = Pattern.compile("([^\",]*|\"[^\"]*\")(,|$)");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                if (matcher.group(1) == null || matcher.group(1).isEmpty()) continue;
                result.add(matcher.group(1));
            }
        }
        return result;
    }

    public static List<String> splitOracleStringList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> splitValue = OraOopUtilities.splitStringList(value);
        Pattern pattern = Pattern.compile("(\")([^\"]*)(\")");
        for (String element : splitValue) {
            Matcher matcher = pattern.matcher(element);
            if (matcher.find()) {
                result.add(matcher.group(2));
                continue;
            }
            result.add(element.toUpperCase());
        }
        return result;
    }

    private static String[] getExtraExportUpdateKeyColumnNames(String updateKey, Configuration conf) {
        if (updateKey == null) {
            return new String[0];
        }
        String extraKeys = conf.get("oraoop.update.key.extra.columns", "");
        if (!extraKeys.isEmpty()) {
            updateKey = updateKey + "," + extraKeys;
        }
        String[] columnNames = updateKey.split(",");
        for (int idx = 0; idx < columnNames.length; ++idx) {
            columnNames[idx] = columnNames[idx].trim();
            if (columnNames[idx].startsWith("\"")) continue;
            columnNames[idx] = columnNames[idx].toUpperCase();
        }
        return columnNames;
    }

    public static OraOopConstants.AppendValuesHintUsage getOracleAppendValuesHintUsage(Configuration conf) {
        OraOopConstants.AppendValuesHintUsage result;
        if (conf == null) {
            throw new IllegalArgumentException("The conf argument cannot be null");
        }
        String strUsage = conf.get("oraoop.oracle.append.values.hint.usage");
        if (strUsage == null) {
            return OraOopConstants.AppendValuesHintUsage.AUTO;
        }
        try {
            strUsage = strUsage.toUpperCase().trim();
            result = OraOopConstants.AppendValuesHintUsage.valueOf(strUsage);
        }
        catch (IllegalArgumentException ex) {
            result = OraOopConstants.AppendValuesHintUsage.AUTO;
            String errorMsg = String.format("An invalid value of \"%s\" was specified for the \"%s\" configuration property value.\n\tValid values are: %s\n\tThe default value of %s will be used.", strUsage, "oraoop.oracle.append.values.hint.usage", OraOopUtilities.getOraOopOracleAppendValuesHintUsageValues(), OraOopConstants.AppendValuesHintUsage.AUTO.name());
            LOG.error(errorMsg);
        }
        return result;
    }

    private static String getOraOopOracleAppendValuesHintUsageValues() {
        OraOopConstants.AppendValuesHintUsage[] values = OraOopConstants.AppendValuesHintUsage.values();
        StringBuilder result = new StringBuilder(2 * values.length - 1);
        for (int idx = 0; idx < values.length; ++idx) {
            OraOopConstants.AppendValuesHintUsage value = values[idx];
            if (idx > 0) {
                result.append(" or ");
            }
            result.append(value.name());
        }
        return result.toString();
    }

    public static String getImportHint(Configuration conf) {
        String result = null;
        result = conf.get("oraoop.import.hint");
        result = result == null || result.trim().isEmpty() ? "" : String.format("/*+ %s */ ", result);
        return result;
    }

    public static void appendJavaSecurityEgd(Configuration conf) {
        String mapredJavaOpts = conf.get("mapred.child.java.opts");
        if (mapredJavaOpts == null || !mapredJavaOpts.contains("-Djava.security.egd")) {
            StringBuilder newMapredJavaOpts = new StringBuilder("-Djava.security.egd=file:///dev/urandom");
            if (mapredJavaOpts != null && !mapredJavaOpts.isEmpty()) {
                newMapredJavaOpts.append(" ").append(mapredJavaOpts);
            }
            String newMapredJavaOptsString = newMapredJavaOpts.toString();
            conf.set("mapred.child.java.opts", newMapredJavaOptsString);
            LOG.debug("Updated mapred.child.java.opts from \"" + mapredJavaOpts + "\" to \"" + newMapredJavaOptsString + "\"");
        }
    }

    public static void checkJavaSecurityEgd() {
        String javaSecurityEgd = System.getProperty("java.security.egd");
        if (!"file:///dev/urandom".equals(javaSecurityEgd)) {
            LOG.warn("System property java.security.egd is not set to file:///dev/urandom - Oracle connections may time out.");
        }
    }

    public static void setCurrentSessionUser(String user) {
        currentSessionUser = user;
    }

    public static class DecodedExportMapperTableName {
        private String mapperId;
        private Object tableDateTime;

        public String getMapperId() {
            return this.mapperId;
        }

        public void setMapperId(String newMapperId) {
            this.mapperId = newMapperId;
        }

        public Object getTableDateTime() {
            return this.tableDateTime;
        }

        public void setTableDateTime(Object newTableDateTime) {
            this.tableDateTime = newTableDateTime;
        }
    }

    public static class JdbcOracleThinConnectionParsingError
    extends Exception {
        private static final long serialVersionUID = 1559860600099354233L;

        public JdbcOracleThinConnectionParsingError(String message) {
            super(message);
        }

        public JdbcOracleThinConnectionParsingError(String message, Throwable cause) {
            super(message, cause);
        }

        public JdbcOracleThinConnectionParsingError(Throwable cause) {
            super(cause);
        }
    }

    public static class JdbcOracleThinConnection {
        private String host;
        private int port;
        private String sid;
        private String service;
        private String tnsName;

        public JdbcOracleThinConnection(String host, int port, String sid, String service, String tnsName) {
            this.host = host;
            this.port = port;
            this.sid = sid;
            this.service = service;
            this.tnsName = tnsName;
        }

        public String toString() {
            if (this.tnsName != null && !this.tnsName.isEmpty()) {
                return String.format("jdbc:oracle:thin:@%s", this.tnsName);
            }
            if (this.sid != null && !this.sid.isEmpty()) {
                return String.format("jdbc:oracle:thin:@%s:%d:%s", this.host, this.port, this.sid);
            }
            if (this.service != null && !this.service.isEmpty()) {
                return String.format("jdbc:oracle:thin:@%s:%d/%s", this.host, this.port, this.service);
            }
            throw new RuntimeException("Unable to generate a JDBC URL, as no TNS name, SID or SERVICE has been provided.");
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getSid() {
            return this.sid;
        }

        public String getService() {
            return this.service;
        }

        public String getTnsName() {
            return this.tnsName;
        }
    }

    public static class OraOopStatsReports {
        private String csvReport;
        private String performanceReport;

        public String getPerformanceReport() {
            return this.performanceReport;
        }

        public void setPerformanceReport(String newPerformanceReport) {
            this.performanceReport = newPerformanceReport;
        }

        public String getCsvReport() {
            return this.csvReport;
        }

        public void setCsvReport(String newCsvReport) {
            this.csvReport = newCsvReport;
        }
    }
}

