/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.SqlManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericJdbcManager
extends SqlManager {
    public static final Log LOG = LogFactory.getLog((String)GenericJdbcManager.class.getName());
    private String jdbcDriverClass;
    private Connection connection;

    public GenericJdbcManager(String driverClass, SqoopOptions opts) {
        super(opts);
        this.jdbcDriverClass = driverClass;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (null == this.connection) {
            this.connection = this.makeConnection();
        }
        return this.connection;
    }

    protected boolean hasOpenConnection() {
        return this.connection != null;
    }

    @Override
    public void discardConnection(boolean doClose) {
        if (doClose && this.hasOpenConnection()) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.discardConnection(true);
    }

    @Override
    public String getDriverClass() {
        return this.jdbcDriverClass;
    }
}

