/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.ImportJobBase;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import com.cloudera.sqoop.orm.AvroSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.sqoop.mapreduce.AvroImportMapper;
import org.apache.sqoop.mapreduce.AvroJob;
import org.apache.sqoop.mapreduce.AvroOutputFormat;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.ParquetImportMapper;
import org.apache.sqoop.mapreduce.ParquetJob;
import org.apache.sqoop.mapreduce.RawKeyTextOutputFormat;
import org.apache.sqoop.mapreduce.SequenceFileImportMapper;
import org.apache.sqoop.mapreduce.TextImportMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.kitesdk.data.mapreduce.DatasetKeyOutputFormat;

public class DataDrivenImportJob
extends ImportJobBase {
    public static final Log LOG = LogFactory.getLog((String)DataDrivenImportJob.class.getName());

    public DataDrivenImportJob(SqoopOptions opts) {
        super(opts, null, DataDrivenDBInputFormat.class, null, null);
    }

    public DataDrivenImportJob(SqoopOptions opts, Class<? extends InputFormat> inputFormatClass, ImportJobContext context) {
        super(opts, null, inputFormatClass, null, context);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        if (this.isHCatJob) {
            LOG.info((Object)"Configuring mapper for HCatalog import job");
            job.setOutputKeyClass(LongWritable.class);
            job.setOutputValueClass(SqoopHCatUtilities.getImportValueClass());
            job.setMapperClass(SqoopHCatUtilities.getImportMapperClass());
            return;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);
        } else if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            String schemaNameOverride = null;
            Schema schema = this.generateAvroSchema(tableName, schemaNameOverride);
            try {
                this.writeAvroSchema(schema);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while writing Avro schema.", (Throwable)e);
            }
            AvroJob.setMapOutputSchema(job.getConfiguration(), schema);
        } else if (this.options.getFileLayout() == SqoopOptions.FileLayout.ParquetFile) {
            Configuration conf = job.getConfiguration();
            String schemaNameOverride = tableName;
            Schema schema = this.generateAvroSchema(tableName, schemaNameOverride);
            String uri = this.getKiteUri(conf, tableName);
            ParquetJob.configureImportJob(conf, schema, uri, this.options.isAppendMode(), this.options.doHiveImport() && this.options.doOverwriteHiveTable());
        }
        job.setMapperClass(this.getMapperClass());
    }

    private String getKiteUri(Configuration conf, String tableName) throws IOException {
        if (this.options.doHiveImport()) {
            String hiveDatabase = this.options.getHiveDatabaseName() == null ? "default" : this.options.getHiveDatabaseName();
            String hiveTable = this.options.getHiveTableName() == null ? tableName : this.options.getHiveTableName();
            return String.format("dataset:hive:/%s/%s", hiveDatabase, hiveTable);
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        return "dataset:" + fs.makeQualified(this.getContext().getDestination());
    }

    private Schema generateAvroSchema(String tableName, String schemaNameOverride) throws IOException {
        ConnManager connManager = this.getContext().getConnManager();
        AvroSchemaGenerator generator = new AvroSchemaGenerator(this.options, connManager, tableName);
        return generator.generate(schemaNameOverride);
    }

    private void writeAvroSchema(Schema schema) throws IOException {
        File schemaFile = new File(this.options.getJarOutputDir(), schema.getName() + ".avsc");
        LOG.info((Object)("Writing Avro schema file: " + schemaFile));
        FileUtils.forceMkdir((File)schemaFile.getParentFile());
        FileUtils.writeStringToFile((File)schemaFile, (String)schema.toString(true));
        try {
            FileUtils.moveFileToDirectory((File)schemaFile, (File)new File(this.options.getCodeOutputDir()), (boolean)true);
        }
        catch (IOException e) {
            LOG.debug((Object)"Could not move Avro schema file to code output directory.", (Throwable)e);
        }
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.options.getHCatTableName() != null) {
            return SqoopHCatUtilities.getImportMapperClass();
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return TextImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            return SequenceFileImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            return AvroImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.ParquetFile) {
            return ParquetImportMapper.class;
        }
        return null;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        if (this.isHCatJob) {
            LOG.debug((Object)"Returning HCatOutputFormat for output format");
            return SqoopHCatUtilities.getOutputFormatClass();
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return RawKeyTextOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            return SequenceFileOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            return AvroOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.ParquetFile) {
            return DatasetKeyOutputFormat.class;
        }
        return null;
    }

    private String buildBoundaryQuery(String col, String query) {
        if (col == null || this.options.getNumMappers() == 1) {
            return "";
        }
        String alias = "t1";
        int dot = col.lastIndexOf(46);
        String qualifiedName = dot == -1 ? col : alias + col.substring(dot);
        ConnManager mgr = this.getContext().getConnManager();
        String ret = mgr.getInputBoundsQuery(qualifiedName, query);
        if (ret != null) {
            return ret;
        }
        return "SELECT MIN(" + qualifiedName + "), MAX(" + qualifiedName + ") " + "FROM (" + query + ") AS " + alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws IOException {
        ConnManager mgr = this.getContext().getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getFetchSize(), this.options.getConnectionParams());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getFetchSize(), this.options.getConnectionParams());
            }
            if (null != tableName) {
                String[] colNames = this.options.getColumns();
                if (null == colNames) {
                    colNames = mgr.getColumnNames(tableName);
                }
                String[] sqlColNames = null;
                if (null != colNames) {
                    sqlColNames = new String[colNames.length];
                    for (int i = 0; i < colNames.length; ++i) {
                        sqlColNames[i] = mgr.escapeColName(colNames[i]);
                    }
                }
                String whereClause = this.options.getWhereClause();
                DataDrivenDBInputFormat.setInput(job, DBWritable.class, mgr.escapeTableName(tableName), whereClause, mgr.escapeColName(splitByCol), sqlColNames);
                if (this.options.getBoundaryQuery() != null) {
                    DataDrivenDBInputFormat.setBoundingQuery(job.getConfiguration(), this.options.getBoundaryQuery());
                }
            } else {
                String inputQuery = this.options.getSqlQuery();
                String sanitizedQuery = inputQuery.replace("$CONDITIONS", " (1 = 1) ");
                String inputBoundingQuery = this.options.getBoundaryQuery();
                if (inputBoundingQuery == null) {
                    inputBoundingQuery = this.buildBoundaryQuery(splitByCol, sanitizedQuery);
                }
                DataDrivenDBInputFormat.setInput(job, DBWritable.class, inputQuery, inputBoundingQuery);
                new DBConfiguration(job.getConfiguration()).setInputOrderBy(splitByCol);
            }
            if (this.options.getRelaxedIsolation()) {
                LOG.info((Object)"Enabling relaxed (read uncommitted) transaction isolation for imports");
                job.getConfiguration().setBoolean("org.apache.sqoop.db.relaxedisolation", true);
            }
            LOG.debug((Object)("Using table class: " + tableClassName));
            job.getConfiguration().set(ConfigurationHelper.getDbInputClassProperty(), tableClassName);
            job.getConfiguration().setLong("sqoop.inline.lob.length.max", this.options.getInlineLobLimit());
            LOG.debug((Object)("Using InputFormat: " + this.inputFormatClass));
            job.setInputFormatClass(this.inputFormatClass);
        }
        finally {
            try {
                mgr.close();
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Error closing connection: " + sqlE));
            }
        }
    }
}

