/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.mapreduce.db.DBSplitter;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class BigDecimalSplitter
implements DBSplitter {
    private static final Log LOG = LogFactory.getLog(BigDecimalSplitter.class);
    private static final BigDecimal MIN_INCREMENT = new BigDecimal(4.9407E-320);

    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        BigDecimal minVal = results.getBigDecimal(1);
        BigDecimal maxVal = results.getBigDecimal(2);
        String lowClausePrefix = colName + " >= ";
        String highClausePrefix = colName + " < ";
        BigDecimal numSplits = new BigDecimal(ConfigurationHelper.getConfNumMaps(conf));
        if (minVal == null && maxVal == null) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        if (minVal == null || maxVal == null) {
            LOG.error((Object)"Cannot find a range for NUMERIC or DECIMAL fields with one end NULL.");
            return null;
        }
        List<BigDecimal> splitPoints = this.split(numSplits, minVal, maxVal);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        BigDecimal start = splitPoints.get(0);
        for (int i = 1; i < splitPoints.size(); ++i) {
            BigDecimal end = splitPoints.get(i);
            if (i == splitPoints.size() - 1) {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + start.toString(), colName + " <= " + end.toString()));
            } else {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + start.toString(), highClausePrefix + end.toString()));
            }
            start = end;
        }
        return splits;
    }

    protected BigDecimal tryDivide(BigDecimal numerator, BigDecimal denominator) {
        try {
            return numerator.divide(denominator);
        }
        catch (ArithmeticException ae) {
            return numerator.divide(denominator, 0);
        }
    }

    protected List<BigDecimal> split(BigDecimal numSplits, BigDecimal minVal, BigDecimal maxVal) throws SQLException {
        ArrayList<BigDecimal> splits = new ArrayList<BigDecimal>();
        BigDecimal splitSize = this.tryDivide(maxVal.subtract(minVal), numSplits);
        if (splitSize.compareTo(MIN_INCREMENT) < 0) {
            splitSize = MIN_INCREMENT;
            LOG.warn((Object)"Set BigDecimal splitSize to MIN_INCREMENT");
        }
        BigDecimal curVal = minVal;
        while (curVal.compareTo(maxVal) <= 0) {
            splits.add(curVal);
            curVal = curVal.add(splitSize);
        }
        if (((BigDecimal)splits.get(splits.size() - 1)).compareTo(maxVal) != 0 || splits.size() == 1) {
            splits.add(maxVal);
        }
        return splits;
    }
}

