/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.text.NumberFormat;

public class PerfCounters {
    private long bytes;
    private long nanoseconds;
    private long startTime;
    private static final double ONE_BILLION = 1.0E9;
    private static final int MAX_PLACES = 4;
    private static final long ONE_GB = 0x40000000L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_KB = 1024L;

    public void addBytes(long more) {
        this.bytes += more;
    }

    public void startClock() {
        this.startTime = System.nanoTime();
    }

    public void stopClock() {
        this.nanoseconds = System.nanoTime() - this.startTime;
    }

    private Double inSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    private String formatBytes() {
        String scale;
        double val;
        if (this.bytes > 0x40000000L) {
            val = (double)this.bytes / 1.073741824E9;
            scale = "GB";
        } else if (this.bytes > 0x100000L) {
            val = (double)this.bytes / 1048576.0;
            scale = "MB";
        } else if (this.bytes > 1024L) {
            val = (double)this.bytes / 1024.0;
            scale = "KB";
        } else {
            val = this.bytes;
            scale = "bytes";
        }
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(4);
        return fmt.format(val) + " " + scale;
    }

    private String formatTimeInSeconds() {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(4);
        return fmt.format(this.inSeconds(this.nanoseconds)) + " seconds";
    }

    private String formatSpeed() {
        String scale;
        double val;
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(4);
        Double seconds = this.inSeconds(this.nanoseconds);
        double speed = (double)this.bytes / seconds;
        if (speed > 1.073741824E9) {
            val = speed / 1.073741824E9;
            scale = "GB";
        } else if (speed > 1048576.0) {
            val = speed / 1048576.0;
            scale = "MB";
        } else if (speed > 1024.0) {
            val = speed / 1024.0;
            scale = "KB";
        } else {
            val = speed;
            scale = "bytes";
        }
        return fmt.format(val) + " " + scale + "/sec";
    }

    public String toString() {
        return this.formatBytes() + " in " + this.formatTimeInSeconds() + " (" + this.formatSpeed() + ")";
    }
}

