from vgg_model import VGGNet
from sklearn.metrics.pairwise import cosine_similarity
import numpy as np

vgg_model = VGGNet()


def compare_pictures_sim(p1, p2):
    f1 = vgg_model.vgg_extract_feat(p1)
    f2 = vgg_model.vgg_extract_feat(p2)
    print(f"f1: {f1}, \nf2: {f2}")
    # 将特征向量从列表转换为 NumPy 数组
    f1 = np.array(f1)
    f2 = np.array(f2)

    print(f"f1: {f1}, \nf2: {f2}")
    # 计算余弦相似度
    f1 = f1.reshape(1, -1)
    f2 = f2.reshape(1, -1)
    similarity = cosine_similarity(f1, f2)
    print(f"余弦相似度: {similarity[0][0]}")


p1 = rf"F:\db_data\WXWork\1688850558010973\Cache\Image\2024-05/企业微信截图_17169558074455.png"
p2 = rf"F:\db_data\WXWork\1688850558010973\Cache\Image\2024-05/企业微信截图_17169558138503.png"

p1 = rf"F:\db_data\WXWork\1688850558010973\Cache\Image\2024-05/企业微信截图_17169558246328.png"
p2 = rf"F:\db_data\WXWork\1688850558010973\Cache\Image\2024-05/企业微信截图_17169558377464.png"

compare_pictures_sim(p1, p2)
