import os
import sys
import time
import traceback

import pandas as pd
os.environ["PYARROW_IGNORE_TIMEZONE"] = "1"
sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.templates_mysql import TemplatesMysql
from utils.db_util import DbTypes, DBUtil


class AsinImageLocalPath(object):

    def __init__(self, site_name='us', img_type='amazon_self'):
        self.site_name = site_name
        self.img_type = img_type
        self.first_local_dir, self.image_table = self.get_first_local_dir()
        # self.engine_srs = DBUtil.get_db_engine(db_type=DbTypes.srs.name, site_name=self.site_name)
        self.engine_doris = DBUtil.get_db_engine(db_type=DbTypes.doris.name, site_name=self.site_name)
        self.engine_mysql = DBUtil.get_db_engine(db_type=DbTypes.mysql.name, site_name=self.site_name)

    def get_first_local_dir(self):
        if self.img_type == 'amazon_self':
            first_local_dir = f"/mnt/data/img_data/amazon_self/{self.site_name}"
            image_table = f'{self.site_name}_self_asin_image'
        elif self.img_type == 'amazon':
            first_local_dir = f"/mnt/data/img_data/amazon/{self.site_name}"
            image_table = f'{self.site_name}_amazon_image'
        elif self.img_type == 'amazon_inv':
            first_local_dir = f"/mnt/data/img_data/amazon_inv/{self.site_name}"
            image_table = f'{self.site_name}_inv_img'
        else:
            first_local_dir = ""
            image_table = ""
        return first_local_dir, image_table

    def read_data(self):
        # sql = f"select img_unique from selection.{self.image_table} where state=1;"
        # df = pd.read_sql(sql, con=self.engine_doris)
        sql = f"SELECT * from us_inv_img_info WHERE updated_at>= CURDATE() - INTERVAL 3 DAY and state =3;"
        df = pd.read_sql(sql, con=self.engine_mysql)
        print(f"sql: {sql}", df.shape)
        return df

    def handle_data(self, df):
        # f"{id_segment}_{id}_{img_id}_{img_type}.jpg"
        # df['img_unique'] = df['id_segment'] + "_" + df['id'] + "_" + df['img_id'] + "_" + df['img_type']
        df['img_unique'] = df['id_segment'].astype(str) + "_" + df['id'].astype(str) + "_" + df['img_id'].astype(str) + "_" + df['img_type']

        if self.img_type in ['amazon_self', 'amazon']:
            df["local_path"] = df.img_unique.apply(lambda x: f"{self.first_local_dir}/{x[:1]}/{x[:2]}/{x[:3]}/{x[:4]}/{x[:5]}/{x[:6]}/{x}.jpg")
        elif self.img_type in ['amazon_inv']:
            df["local_path"] = df.img_unique.apply(lambda x: f"{self.first_local_dir}/{x.split('_')[0]}/{x}.jpg")
        df["img_type"] = self.img_type
        df["site_name"] = self.site_name
        df["state"] = 1
        df = df.loc[:, ["img_unique", "site_name", "local_path", "img_type", "state"]]
        print(f"此次更新图片的数量: {df.shape}", df.head(5))
        # quit()
        return df

    def save_data(self, df):
        df.to_sql("img_local_path", con=self.engine_doris, if_exists="append", index=False)

    def run(self):
        df = self.read_data()
        df = self.handle_data(df)
        self.save_data(df)


if __name__ == '__main__':
    site_name = sys.argv[1]  # 参数1：站点
    img_type = sys.argv[2]  # 参数2：图片来源类型
    # site_name = 'us'
    # img_type = "amazon_inv"
    handle_obj = AsinImageLocalPath(site_name=site_name, img_type=img_type)
    handle_obj.run()