import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.db_util import DBUtil
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil, DateTypes

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    #  获取最后一个参数
    test_flag = CommonUtil.get_sys_arg(len(sys.argv) - 1, None)
    print(f"执行参数为{sys.argv}")
    CommonUtil.judge_is_work_hours(site_name=site_name, date_type=date_type, date_info=date_info,
                                   principal='chenyuanjie',
                                   priority=2, export_tools_type=1, belonging_to_process='店铺流程')

    if test_flag == 'test':
        db_type = 'postgresql_test'
        print("导出到测试库中")
    else:
        # db_type = "postgresql"
        # print("导出到PG库中")
        db_type = "postgresql_cluster"
        print("导出到PG集群库库中")

    year_str = CommonUtil.safeIndex(date_info.split("-"), 0, None)
    suffix = str(date_info).replace("-", "_")
    base_tb = f"{site_name}_fb_category_report"
    export_master_tb = f"{base_tb}_{year_str}"
    export_tb = f"{base_tb}_{suffix}"
    next_month = CommonUtil.get_next_val(date_type, date_info)

    # 获取数据库连接
    engine = DBUtil.get_db_engine(db_type, site_name)


    # 保证幂等性，先删除原始表同周期的数据
    sql = f"""
         drop table if exists {export_tb};
         create table if not exists {export_tb} 
                (
                like {export_master_tb}  including comments
         );
    """
    DBUtil.engine_exec_sql(engine, sql)

    # 导出agg表
    sh_report = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_fb_category_report",
        export_tb=export_tb,
        col=[
            "seller_id",
            "bsr_cate_1_id",
            "bsr_cate_1_name",
            "fb_cate_asin_num",
            "fb_cate_new_asin_num",
            "fb_asin_num",
            "bsr_asin_num",
            "fb_cate_asin_rate",
            "fb_cate_new_asin_rate",
            "fb_market_rate",
            "date_info",
            "created_time",
            "updated_time"
        ],
        partition_dict={
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh_report, ignore_err=False)


    client.close()
    # 创建索引并交换分区
    DBUtil.add_pg_part(
        engine,
        source_tb_name=export_tb,
        part_master_tb=export_master_tb,
        part_val={
            "from": [date_info],
            "to": [next_month]
        },
        cp_index_flag=False,
    )

    update_workflow_sql = f"""                
                        update selection.workflow_progress set `status`='导出pg集群完成', status_val=6, over_date=CURRENT_TIME, is_end='是' where page='店铺Feedback' 
                        and `date_info`='{date_info}' and date_type='{date_type}' and site_name='{site_name}'
                    """
    CommonUtil.modify_export_workflow_status(update_workflow_sql, site_name, date_type, date_info)

    # 关闭链接
    engine.dispose()
    print("success")

    print("success")

