import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.templates import Templates
from utils.templates_mysql import TemplatesMysql
# from ..utils.templates import Templates
# from ..utils.templates_mysql import TemplatesMysql


class GetUsAsin(Templates):

    def __init__(self, site_name='us'):
        super().__init__()
        self.site_name = site_name
        self.templates_mysql = TemplatesMysql()
        self.db_save = f"dwd_self_asin_test"
        self.spark = self.create_spark_object(app_name=f"{self.db_save} {self.site_name}, {self.date_info}")
        self.df_self_asin = self.spark.sql("select 1+1;")
        self.df_asin_history = self.spark.sql("select 1+1;")
        self.df_save = self.spark.sql("select 1+1;")

    def read_data(self):
        sql = f"select asin from ods_self_asin where site_name='{self.site_name}'"
        print("sql:", sql)
        self.df_self_asin = self.spark.sql(sql).cache()
        sql = f"select asin, asin_img_type from dim_cal_asin_history_detail where site_name='{self.site_name}'"
        print("sql:", sql)
        self.df_asin_history = self.spark.sql(sql).cache()

    def handle_data(self):
        self.df_save = self.df_self_asin.join(
            self.df_asin_history, on='asin', how='left'
        )
        self.df_save.show(10, truncate=False)
        df = self.df_save.toPandas()
        df.to_csv(f"/root/{self.site_name}_self_asin.csv", index=False)
        quit()


if __name__ == '__main__':
    site_name = sys.argv[1]  # 参数1：站点
    handle_obj = GetUsAsin(site_name=site_name)
    handle_obj.run()