import os
import sys
import re

sys.path.append(os.path.dirname(sys.path[0]))  # 上级目录
from utils.templates import Templates
# from ..utils.templates import Templates
from pyspark.sql import functions as F
from pyspark.sql.window import Window
from pyspark.sql.types import StructType, StructField, IntegerType, StringType


class DimBsAsinInfo(Templates):

    def __init__(self, site_name='us', date_type="month", date_info='2022-1'):
        super().__init__()
        self.site_name = site_name
        self.date_type = date_type
        self.date_info = date_info
        # 初始化self.spark对
        self.db_save = 'dim_asin_bs_info'
        self.spark = self.create_spark_object(
            app_name=f"{self.db_save}: {self.site_name}, {self.date_type}, {self.date_info}")

    def read_data(self):
        sql = f"SELECT asin, bsr_orders, asin_brand_name , category_id, date_info  from dwt_flow_asin WHERE site_name ='us' and date_type ='month' and category_id='3024192011' and asin_brand_name in ('rabbitgoo', 'icefang')"
        self.df_save = self.spark.sql(sql).cache()
        self.df_save.show(100, truncate=False)

    def handle_data(self):
        df = self.df_save.toPandas()
        print("df.shape:", df.shape)
        df.to_csv("/root/tmp_cate_brand.csv", index=False)

    def save_data(self):
        pass


if __name__ == '__main__':
    handle_obj = DimBsAsinInfo()
    handle_obj.run()