#! /bin/env bash


# author: 黄舰
# description: 基于dwd_st_asin_info、dwd_st_measure表，计算出top10 zr类型搜索词asin和ac类型asin
# table_read_name: dwd_st_asin_info, dwd_st_measure
# table_save_name: dwt_st_top_asin_info
# table_save_level: dwt
# version: 1.0
# created_date: 2022-02-14
# updated_date: 2023-02-14


if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi

date_type=$2
date_info=$3
hive_table=dwt_st_top_asin_info
hive_level=dwt


for site_name in ${site_name_array[*]}
        do
                echo "site_name: ${site_name}","date_type: ${date_type}","date_info: ${date_info}"
                hdfs dfs -rm -r /home/big_data_selection/${hive_level}/${hive_table}/site_name=${site_name}/date_type=${date_type}/date_info=${date_info}/*
                # spark-yarn提交指令
                /opt/module/spark/bin/spark-submit \
                --master yarn \
                --driver-memory 10g \
                --executor-memory 20g \
                --executor-cores 4 \
                --num-executors 15 \
                --queue spark \
                /opt/module/spark/demo/py_demo/${hive_level}/${hive_table}.py ${site_name} ${date_type} ${date_info}
        done

