import json

from utils.datahub_util import build_column_lineages

to_tb = "dim_asin_detail"
sources = [
    {
        "form": "ods_asin_detail",
        "mappings": [
            ("asin", "asin"),
            ("img_url", "asin_img_url"),
            ("title", "asin_title"),
            ("title_len", "asin_title_len"),
            ("price", "asin_price"),
            ("rating", "asin_rating"),
            ("total_comments", "asin_total_comments"),
            ("buy_box_seller_type", "asin_buy_box_seller_type"),
            ("page_inventory", "asin_page_inventory"),
            ("category", "asin_category_desc"),
            ("volume", "asin_volume"),
            ("rank", "asin_rank"),
            ("launch_time", "asin_launch_time"),
            ("img_num", "asin_img_num"),
            ("img_type", "asin_img_type"),
            ("category_state", "asin_category_state"),
            ("material", "asin_material"),
            ("brand", "asin_brand_name"),
            ("activity_type", "asin_activity_type"),
            ("one_two_val", "act_one_two_val"),
            ("three_four_val", "act_three_four_val"),
            ("five_six_val", "act_five_six_val"),
            ("eight_val", "act_eight_val"),
            ("qa_num", "qa_num"),
            ("one_star", "one_star"),
            ("two_star", "two_star"),
            ("three_star", "three_star"),
            ("four_star", "four_star"),
            ("five_star", "five_star"),
            ("low_star", "low_star"),
            ("together_asin", "together_asin"),
            ("ac_name", "ac_name"),
            ("node_id", "node_id"),
            ("data_type", "asin_data_type"),
            ("sp_num", "sp_num"),
            ("describe", "asin_describe"),
            ("package_quantity", "asin_package_quantity"),
            ("pattern_name", "asin_pattern_name"),
        ]
    },
    {
        "form": "dim_asin_variation_info",
        "mappings": [
            ("parent_asin", "parent_asin"),
            ("color", "asin_color"),
            ("size", "asin_size"),
            ("style", "asin_style"),
            ("state", "asin_is_sale"),
        ]
    },
    {
        "form": "ods_asin_keep_date",
        "mappings": [
            ("launch_time", "asin_launch_time"),
        ]
    },
    {
        "form": "ods_other_search_term_data",
        "mappings": [
            ("label", "asin_label_list"),
        ]
    },
    {
        "form": "ods_other_search_term_data",
        "mappings": [
            ("weight_str", "asin_weight_str"),
            ("weight", "asin_weight"),
            ("weight_type", "asin_weight_type"),
        ]
    },

]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
