/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ProgressThread
extends Thread {
    private static Log log = null;
    private int maxProgressPeriod;
    private int sleepInterval;
    private int reportInterval;
    public static final String MAX_PROGRESS_PERIOD_KEY = "sqoop.mapred.auto.progress.max";
    public static final String SLEEP_INTERVAL_KEY = "sqoop.mapred.auto.progress.sleep";
    public static final String REPORT_INTERVAL_KEY = "sqoop.mapred.auto.progress.report";
    public static final int DEFAULT_SLEEP_INTERVAL = 10000;
    public static final int DEFAULT_REPORT_INTERVAL = 30000;
    public static final int DEFAULT_MAX_PROGRESS = 0;
    private volatile boolean keepGoing;
    private TaskInputOutputContext context;
    private long startTimeMillis;
    private long lastReportMillis;

    public ProgressThread(TaskInputOutputContext ctxt, Log log) {
        this.context = ctxt;
        ProgressThread.log = log;
        this.keepGoing = true;
        this.configureAutoProgress(ctxt.getConfiguration());
    }

    private void configureAutoProgress(Configuration job) {
        this.maxProgressPeriod = job.getInt(MAX_PROGRESS_PERIOD_KEY, 0);
        this.sleepInterval = job.getInt(SLEEP_INTERVAL_KEY, 10000);
        this.reportInterval = job.getInt(REPORT_INTERVAL_KEY, 30000);
        if (this.reportInterval < 1) {
            log.warn((Object)"Invalid sqoop.mapred.auto.progress.report; setting to 30000");
            this.reportInterval = 30000;
        }
        if (this.sleepInterval > this.reportInterval || this.sleepInterval < 1) {
            log.warn((Object)"Invalid sqoop.mapred.auto.progress.sleep; setting to 10000");
            this.sleepInterval = 10000;
        }
        if (this.maxProgressPeriod < 0) {
            log.warn((Object)"Invalid sqoop.mapred.auto.progress.max; setting to 0");
            this.maxProgressPeriod = 0;
        }
    }

    public void signalShutdown() {
        this.keepGoing = false;
        this.interrupt();
    }

    @Override
    public void run() {
        this.startTimeMillis = this.lastReportMillis = System.currentTimeMillis();
        long MAX_PROGRESS = this.maxProgressPeriod;
        long REPORT_INTERVAL = this.reportInterval;
        long SLEEP_INTERVAL = this.sleepInterval;
        while (this.keepGoing) {
            long curTimeMillis = System.currentTimeMillis();
            if (MAX_PROGRESS != 0L && curTimeMillis - this.startTimeMillis > MAX_PROGRESS) {
                this.keepGoing = false;
                log.info((Object)("Auto-progress thread exiting after " + MAX_PROGRESS + " ms."));
                break;
            }
            if (curTimeMillis - this.lastReportMillis > REPORT_INTERVAL) {
                log.debug((Object)"Auto-progress thread reporting progress");
                this.context.progress();
                this.lastReportMillis = curTimeMillis;
            }
            if (Thread.interrupted()) continue;
            try {
                Thread.sleep(SLEEP_INTERVAL);
            }
            catch (InterruptedException ie) {}
        }
        log.info((Object)("Auto-progress thread is finished. keepGoing=" + this.keepGoing));
    }
}

